% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_mixture_from_genotypes.R
\name{sample_mixture_from_genotypes}
\alias{sample_mixture_from_genotypes}
\title{Sample mixture profile with provided genotypes}
\usage{
sample_mixture_from_genotypes(genotypes, model, sample_name = "mixture")
}
\arguments{
\item{genotypes}{List of contributor genotypes. See \link{sample_contributor_genotypes}.}

\item{model}{pg_model object.}

\item{sample_name}{Character. Defaults to "mixture".}
}
\value{
DataFrame with at least SMASH columns (see \link{SMASH_to_wide_table}). Depending on the chosen \code{pg_model} (e.g. \link{gamma_model} or \link{log_normal_model}), other columns with further details about the simulation are returned as well.
}
\description{
Sample mixture profile with provided genotypes
}
\details{
A mixture profile is sampled according to the provided \code{pg_model} (see \link{gamma_model}, \link{log_normal_model} and genotypes (see \link{sample_contributor_genotypes}).
}
\examples{
# read allele frequencies and kit data
freqs <- read_allele_freqs(system.file("extdata","FBI_extended_Cauc.csv",
                           package = "simDNAmixtures"))
data(gf)

# define a pedigree of siblings S1 and S2 (and their parents)
ped_sibs <- pedtools::nuclearPed(children = c("S1", "S2"))

# sample genotypes for a mixture of S1 + U1 + S2
# where U1 is an unrelated person
genotypes <- sample_contributor_genotypes(contributors = c("S1","U1","S2"),
freqs, ped_sibs, loci = gf$autosomal_markers)

# define a gamma model for peak heights
gamma_model <- gamma_model(mixture_proportions = c(0.5, 0.3, 0.2), mu = 1000.,
                    cv = 0.1, model_settings = gf$gamma_settings_no_stutter)

# sample mixture from genotypes
mix <- sample_mixture_from_genotypes(genotypes, gamma_model)
}
\seealso{
\link{sample_mixtures} for a function that samples many mixtures in one go.
}
