% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stop.cat.R
\name{stop.cat}
\alias{stop.cat}
\title{Check if the CAT ended}
\usage{
stop.cat(
  rule = list(se = NULL, delta.theta = NULL, hypo = NULL, hyper = NULL, info = NULL,
    max.items = NULL, min.items = NULL, fixed = NULL),
  current = list(se = NULL, delta.theta = NULL, info = NULL, applied = NULL, delta.se =
    NULL)
)
}
\arguments{
\item{rule}{list with stopping rules
\itemize{
\item \code{se} minimum standard error
\item \code{delta.theta} minimum absolute difference between current and previous theta
\item \code{hypo} minimum standard error reduction
\item \code{hyper} minimum standard error reduction after achieving \code{se}
\item \code{info} maximum information of an available item
\item \code{max.items} maximum number of items
\item \code{min.items} maximum number of items
\item \code{fixed} fixed number of items
}}

\item{current}{list with current values
\itemize{
\item \code{se} current standard error
\item \code{delta.theta} absolute difference between current and previous theta
\item \code{info} maximum information of an available item for current theta
\item \code{applied} quantitative of applied items
\item \code{delta.se} standard error reduction
}}
}
\value{
A list with two elements:
\itemize{
\item \code{stop} \code{TRUE} if any stopping rule has been achieved
\item \code{convergence} logical. \code{FALSE} if the CAT stopped because it
achieved the maximum number of items. \code{TRUE} for any other case.
}
}
\description{
Check if any stopping rule has been achieved
}
\author{
Alexandre Jaloto
}
