% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signature_series.R
\name{sig_assign_samples}
\alias{sig_assign_samples}
\title{Return sample clustering from NMF run results}
\usage{
sig_assign_samples(nmfObj, type = "consensus", matchConseOrder = F)
}
\arguments{
\item{nmfObj}{a \code{NMF} result object which is an element return from \link{sig_extract}
or run results of \strong{NMF} package.}

\item{type}{cluster type, could be 'consensus' or 'samples'.}

\item{matchConseOrder}{if \code{TRUE}, the result will match order as shown in consensus map
when type argument is 'consensus'.}
}
\value{
a \code{data.table} object
}
\description{
One of key results from NMF decomposition is to cluster samples into different
groups. This function takes NMF result (a \code{NMF} object) as input
and return the membership in each cluster.
}
\details{
X = W x H

W is the feature matrix, H is the sample matrix
After NMF run, use this function to select import features and assign groups for the two matrix.

More detail please see \code{\link[NMF:predict]{NMF::predict()}}.
}
\examples{
# Load copy number signature
load(system.file("extdata", "toy_copynumber_signature.RData",
  package = "sigminer", mustWork = TRUE
))
# Assign samples to clusters
subtypes <- sig_assign_samples(res$nmfObj, type = "samples")
}
\seealso{
Other signature analysis series function: \code{\link{sig_estimate}},
  \code{\link{sig_extract}},
  \code{\link{sig_get_activity}},
  \code{\link{sig_get_correlation}},
  \code{\link{sig_get_similarity}},
  \code{\link{sig_prepare}},
  \code{\link{sig_summarize_subtypes}}
}
\concept{signature analysis series function}
