% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{sg_nodes}
\alias{sg_nodes}
\alias{sg_edges}
\alias{sg_edges2}
\alias{sg_nodes2}
\title{Add nodes and edges}
\usage{
sg_nodes(sg, data, ...)

sg_edges(sg, data, ...)

sg_edges2(sg, data)

sg_nodes2(sg, data)
}
\arguments{
\item{sg}{An object of class \code{sigmajs}as intatiated by \code{\link{sigmajs}}.}

\item{data}{Data.frame (or list) of nodes or edges.}

\item{...}{Any column name, see details.}
}
\description{
Add nodes and edges to a \code{sigmajs} graph.
}
\details{
\strong{nodes}:
Must pass \code{id} (\emph{unique}), \code{size} and \code{color}. If \code{color} is omitted than specify 
\code{defaultNodeColor} in \code{\link{sg_settings}} otherwise nodes will be transparent. Ideally nodes 
also include \code{x} and \code{y}, 
if they are not passed then they are randomly generated, you can either get these coordinates with \code{\link{sg_get_layout}}
or \code{\link{sg_layout}}.

\strong{edges}:
Each edge also must include a unique \code{id} as well as two columns named \code{source} and \code{target} which correspond to
node \code{id}s. If an edges goes from or to an \code{id} that is not in node \code{id}.
}
\note{
\code{node} also takes a \link[crosstalk]{SharedData}.
}
\section{Functions}{

\itemize{
	\item{Functions ending in \code{2} take a list like the original sigma.js JSON.}
	\item{Other functions take the arguments described above.}
}
}

\examples{
nodes <- sg_make_nodes()
edges <- sg_make_edges(nodes)

sg <- sigmajs() \%>\%
  sg_nodes(nodes, id, label, size, color) \%>\%
  sg_edges(edges, id, source, target) 
  
sg # no layout

# layout
sg \%>\% 
  sg_layout()

# directed graph
edges$type <- "arrow" # directed

# omit color
sigmajs() \%>\%
  sg_nodes(nodes, id, label, size) \%>\%
  sg_edges(edges, id, source, target, type) \%>\% 
  sg_settings(defaultNodeColor = "#141414")
  
# all source and target are present in node ids
all(c(edges$source, edges$target) \%in\% nodes$id)

}
