% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigmaAttrs.R
\name{addInteraction}
\alias{addInteraction}
\title{Modify the interactivity of a 'sigmaNet' object.}
\usage{
addInteraction(sigmaObj, neighborEvent = "onClick", doubleClickZoom = TRUE,
  mouseWheelZoom = TRUE)
}
\arguments{
\item{sigmaObj}{A 'sigmaNet' object - created using the 'sigmaFromIgraph' function}

\item{neighborEvent}{Enable/disable event that highlights a node's neighbors.  Can either be onClick, onHover, or None.}

\item{doubleClickZoom}{Enable/disable zoom event on double click}

\item{mouseWheelZoom}{Enable/disable zoom event on mouse wheel}
}
\description{
Modify the interactivity of a 'sigmaNet' object using the below options.  By default, visualizations
include on-click neighbor events, double-click zoom, and mouse-wheel zoom.  These can all be disabled
or modified per the below options.
}
\examples{
library(igraph)
library(sigmaNet)
library(magrittr)

data(lesMis)

l <- layout_nicely(lesMis)
#change neighbor highlighting to on-hover, disable double-click zoom, enable mouse-wheel zoom
sig <- sigmaFromIgraph(graph = lesMis, layout = l) \%>\%
  addInteraction(neighborEvent = 'onHover', doubleClickZoom = FALSE, mouseWheelZoom = TRUE)
sig

}
