% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shrinkTVP_methods.R
\name{predict.shrinkTVP}
\alias{predict.shrinkTVP}
\title{Calculate predicted historical values for an estimated TVP model}
\usage{
\method{predict}{shrinkTVP}(object, ...)
}
\arguments{
\item{object}{a \code{shrinkTVP} object}

\item{...}{Currently ignored.}
}
\value{
An object of class \code{shrinkTVP_pred}.
}
\description{
Calculates the predicted past values for an estimated TVP model, i.e. \eqn{X_t'\beta_t + \epsilon_t}.
Note that in contrast to \code{\link{fitted.shrinkTVP}} this includes the error term.
}
\examples{
\donttest{

# Generate synthetic data
sim <- simTVP(N = 300)

# Estimate a model
res <- shrinkTVP(y ~ x1 + x2, sim$data)

# Calculate predicted values
pred <- predict(res)

# Visualize
plot(pred)
lines(sim$data$y, col = "forestgreen")
}
}
\seealso{
Other prediction functions: 
\code{\link{LPDS}()},
\code{\link{eval_pred_dens}()},
\code{\link{fitted.shrinkTVP}()},
\code{\link{forecast_shrinkTVP}()},
\code{\link{residuals.shrinkTVP}()}
}
\author{
Peter Knaus \email{peter.knaus@wu.ac.at}
}
\concept{prediction functions}
