% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot.shrinkTVP}
\alias{plot.shrinkTVP}
\title{Graphical summary of posterior distribution}
\usage{
\method{plot}{shrinkTVP}(
  x,
  pars = c("beta"),
  nplot = 3,
  h_borders = c(0.05, 0.05),
  w_borders = c(0.02, 0.02),
  ...
)
}
\arguments{
\item{x}{a \code{shrinkTVP} object.}

\item{pars}{a character vector containing the names of the parameters to be visualized.
The names have to coincide with the names of the list elements of the \code{shrinkTVP}
object. Throws an error if any element of \code{pars} does not fulfill this criterium.
The default is \code{c("beta")}.}

\item{nplot}{positive integer that indicates the number of tvp plots to display on a single
page before a new page is generated. The default value is 3.}

\item{h_borders}{single real, positive number smaller than 0.5 or a vector containing two such numbers. Determines
the relative amount of space (the total amount summing up to 1) left blank on the left and right of the plot, in that order.
The default is \code{c(0.05, 0.05)}.}

\item{w_borders}{single real, positive number smaller than 0.5 or a vector containing two such numbers. Determines
the relative amount of space (the total amount summing up to 1) left blank at the top and bottom of the plot, in that order.
The default is \code{c(0.02, 0.02)}.}

\item{...}{further arguments to be passed to the respective plotting functions.}
}
\value{
Called for its side effects and returns invisibly.
}
\description{
\code{plot.shrinkTVP} generates plots visualizing the posterior distribution.
}
\examples{
\donttest{
set.seed(123)
sim <- simTVP(theta = c(0.2, 0, 0), beta_mean = c(1.5, -0.3, 0))
data <- sim$data

output <- shrinkTVP(y ~ x1 + x2, data)
plot(output)
}

## Will produce an error because 'hello' is not a parameter in the model
\dontrun{
plot(output, pars = c("beta", "hello"))
}

}
\seealso{
Other plotting functions: 
\code{\link{plot.mcmc.tvp}()},
\code{\link{plot.shrinkTVP_forc}()}
}
\author{
Peter Knaus \email{peter.knaus@wu.ac.at}
}
\concept{plotting functions}
