% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-air-resistance.R
\name{get_air_resistance}
\alias{get_air_resistance}
\title{Get Air Resistance}
\usage{
get_air_resistance(
  velocity,
  bodymass = 75,
  bodyheight = 1.75,
  barometric_pressure = 760,
  air_temperature = 25,
  wind_velocity = 0
)
}
\arguments{
\item{velocity}{Instantaneous running velocity in meters per second (m/s)}

\item{bodymass}{In kilograms (kg). Default is 75kg}

\item{bodyheight}{In meters (m). Default is 1.75m}

\item{barometric_pressure}{In Torrs. Default is 760Torrs}

\item{air_temperature}{In Celzius (C). Default is 25C}

\item{wind_velocity}{In meters per second (m/s). Use negative number as head
wind, and positive number as back wind. Default is 0m/s (no wind)}
}
\value{
Air resistance in Newtons (N)
}
\description{
\code{get_air_resistance} estimates air resistance in Newtons
}
\examples{
get_air_resistance(
  velocity = 5,
  bodymass = 80,
  bodyheight = 1.90,
  barometric_pressure = 760,
  air_temperature = 16,
  wind_velocity = -0.5
)
}
\references{
Arsac LM, Locatelli E. 2002. Modeling the energetics of 100-m running by using speed curves of
        world champions. Journal of Applied Physiology 92:1781–1788.
        DOI: 10.1152/japplphysiol.00754.2001.

    Samozino P, Rabita G, Dorel S, Slawinski J, Peyrot N, Saez de Villarreal E, Morin J-B. 2016.
        A simple method for measuring power, force, velocity properties, and mechanical
        effectiveness in sprint running: Simple method to compute sprint mechanics.
        Scandinavian Journal of Medicine & Science in Sports 26:648–658. DOI: 10.1111/sms.12490.

    van Ingen Schenau GJ, Jacobs R, de Koning JJ. 1991. Can cycle power predict sprint running
       performance? European Journal of Applied Physiology and Occupational Physiology 63:255–260.
       DOI: 10.1007/BF00233857.
}
