% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probe-functions.R
\name{probe_functions}
\alias{probe_functions}
\alias{probe_FV}
\alias{probe_MSS_MAC}
\title{Probe profile functions}
\usage{
probe_FV(distance, F0, V0, bodymass = 75, perc = 2.5, ...)

probe_MSS_MAC(distance, MSS, MAC, perc = 2.5)
}
\arguments{
\item{distance}{Numeric vector}

\item{F0, V0}{Numeric vectors. FV profile parameters}

\item{bodymass}{Body mass in kg}

\item{perc}{Numeric vector. Probing percentage. Default is 2.5 percent}

\item{...}{Forwarded to \code{\link{predict_power_at_distance}} for the purpose of calculation of air resistance}

\item{MSS, MAC}{Numeric vectors. Model parameters}
}
\value{
\code{probe_FV} returns a data frame with the following columns
    \describe{
        \item{F0}{Original F0}
        \item{V0}{Original F0}
        \item{bodymass}{Bodymass}
        \item{Pmax}{Maximal power estimated using F0 * V0 / 4}
        \item{Pmax_rel}{Relative maximal power}
        \item{slope}{FV profile slope}
        \item{distance}{Distance}
        \item{time}{Time to cover distance}
        \item{probe_perc}{Probe percentage}
        \item{F0_probe}{Probing F0}
        \item{F0_probe_time}{Predicted time for distance when F0 is probed}
        \item{F0_probe_time_gain}{Difference in time to cover distance between time_optimal and time}
        \item{V0_probe}{Probing V0}
        \item{V0_probe_time}{Predicted time for distance when V0 is probed}
        \item{V0_probe_time_gain}{Difference in time to cover distance between time_optimal and time}
        \item{profile_imb}{Percent ratio between V0_probe_time_gain and F0_probe_time_gain}
   }

\code{probe_MSS_MAC} returns a data frame with the following columns
    \describe{
        \item{MSS}{Original MSS}
        \item{MAC}{Original MAC}
        \item{Pmax_rel}{Relative maximal power estimated using MSS * MAC / 4}
        \item{slope}{Sprint profile slope}
        \item{distance}{Distance}
        \item{time}{Time to cover distance}
        \item{probe_perc}{Probe percentage}
        \item{MSS_probe}{Probing MSS}
        \item{MSS_probe_time}{Predicted time for distance when MSS is probed}
        \item{MSS_probe_time_gain}{Difference in time to cover distance between probe time and time}
        \item{MAC_probe}{Probing MAC}
        \item{MAC_probe_time}{Predicted time for distance when MAC is probed}
        \item{MAC_probe_time_gain}{Difference in time to cover distance between probing time and time}
        \item{profile_imb}{Percent ratio between MSS_probe_time_gain and MAC_probe_time_gain}
   }
}
\description{
Family of functions that serve a purpose of probing sprint or force-velocity profile. This is done
    by increasing individual sprint parameter for a percentage and calculating which parameter
    imptovement yield biggest deduction in sprint tim

\code{probe_FV} "probes" \code{F0} and \code{V0} and calculates which one
    improves sprint time for a defined \code{distance}

\code{probe_MSS_MAC} "probes" \code{MSS} and \code{MAC} and calculates which one
    improves sprint time for a defined \code{distance}
}
\examples{
MSS <- 10
MAC <- 8
bodymass <- 75

fv <- make_FV_profile(MSS, MAC, bodymass)

dist <- seq(5, 40, by = 5)

probe_MSS_MAC_profile <- probe_MSS_MAC(
  distance = dist,
  MSS,
  MAC
)[["profile_imb"]]

probe_FV_profile <- probe_FV(
  distance = dist,
  fv$F0_poly,
  fv$V0_poly,
  fv$bodymass
)[["profile_imb"]]

plot(x = dist, y = probe_MSS_MAC_profile, type = "l", ylab = "Profile imbalance")
lines(x = dist, y = probe_FV_profile, type = "l", col = "blue")
abline(h = 100, col = "gray", lty = 2)
}
