% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_using_split_times.R
\name{model_using_split_times}
\alias{model_using_split_times}
\title{Model Using Split Times}
\usage{
model_using_split_times(distance, time, weights = 1, na.rm = FALSE)
}
\arguments{
\item{distance}{Numeric vector}

\item{time}{Numeric vector}

\item{weights}{Numeric vector. Default is vector of 1
This is used to give more weight to particular observations. For example, use \code{1\\distance} to give
more weight to observations from shorter distances.}

\item{na.rm}{Logical. Default is FALSE}
}
\value{
List object with the following elements:
    \describe{
        \item{parameters}{List with the following estimated parameters:
            \code{MSS}, \code{TAU}, \code{MAC}, and \code{PMAX}}
        \item{model_fit}{List with the following components:
            \code{RSE}, \code{R_squared}, \code{minErr}, \code{maxErr},
            \code{maxAbsErr}, and \code{RMSE}}
        \item{model}{Model returned by the \code{\link[stats]{nls}} function}
        \item{data}{Data frame used to estimate the sprint parameters, consisting of \code{distance},
            \code{time}, \code{weights} and \code{pred_time} columns}
        }
}
\description{
This function models the sprint split times using mono-exponential equation that estimates
    maximum sprinting speed (\code{MSS}) and relative acceleration (\code{TAU}). \code{time} is used as target or outcome
    variable, and \code{distance} as predictor.
}
\examples{
split_times <- data.frame(
distance = c(5, 10, 20, 30, 35),
time = c(1.21, 1.99, 3.38, 4.71, 5.30)
)

sprint_model <- with(
  split_times,
  model_using_split_times(distance, time)
)

sprint_model$parameters
}
