% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metareactive.R
\name{metaReactive}
\alias{metaReactive}
\alias{metaReactive2}
\title{Create a meta-reactive expression}
\usage{
metaReactive(
  expr,
  env = parent.frame(),
  quoted = FALSE,
  varname = NULL,
  domain = shiny::getDefaultReactiveDomain(),
  inline = FALSE,
  localize = "auto",
  bindToReturn = FALSE
)

metaReactive2(
  expr,
  env = parent.frame(),
  quoted = FALSE,
  varname = NULL,
  domain = shiny::getDefaultReactiveDomain(),
  inline = FALSE
)
}
\arguments{
\item{expr}{An expression (quoted or unquoted).}

\item{env}{The parent environment for the reactive expression. By default,
this is the calling environment, the same as when defining an ordinary
non-reactive expression. If \code{x} is a quosure and \code{quoted} is \code{TRUE},
then \code{env} is ignored.}

\item{quoted}{If it is \code{TRUE}, then the \code{\link[=quote]{quote()}}ed value of \code{x}
will be used when \code{x} is evaluated. If \code{x} is a quosure and you
would like to use its expression as a value for \code{x}, then you must set
\code{quoted} to \code{TRUE}.}

\item{varname}{An R variable name that this object prefers to be named when
its code is extracted into an R script. (See also: \code{\link[=expandChain]{expandChain()}})}

\item{domain}{See \link[shiny]{domains}.}

\item{inline}{If \code{TRUE}, during code expansion, do not declare a variable for
this object; instead, inline the code into every call site. Use this to avoid
introducing variables for very simple expressions. (See also: \code{\link[=expandChain]{expandChain()}})}

\item{localize}{Whether or not to wrap the returned expression in \code{\link[=local]{local()}}.
The default, \code{"auto"}, only wraps expressions with a top-level \code{\link[=return]{return()}}
statement (i.e., return statements in anonymized functions are ignored).}

\item{bindToReturn}{For non-\code{localize}d expressions, should an assignment
of a meta expression be applied to the \emph{last child} of the top-level \verb{\\\{} call?}
}
\value{
A function that, when called in meta mode (i.e. inside
\code{\link[=expandChain]{expandChain()}}), will return the code in quoted form. When called outside
meta mode, it acts the same as a regular \code{\link[shiny:reactive]{shiny::reactive()}} expression
call.
}
\description{
Create a \code{\link[=reactive]{reactive()}} that, when invoked with meta-mode activated
(i.e. called within \code{\link[=withMetaMode]{withMetaMode()}} or \code{\link[=expandChain]{expandChain()}}), returns a
code expression (instead of evaluating that expression and returning the value).
}
\details{
If you wish to capture specific code inside of \code{expr} (e.g. ignore code
that has no meaning outside shiny, like \code{\link[=req]{req()}}), use \code{metaReactive2()} in combination
with \code{metaExpr()}. When using \code{metaReactive2()}, \code{expr} must return a \code{metaExpr()}.

If \code{varname} is unspecified, \link{srcref}s are used in attempt to infer the name
bound to the meta-reactive object. In order for this inference to work, the
\code{keep.source} \link{option} must be \code{TRUE} and \code{expr} must begin with \verb{\\\{}.
}
\examples{

library(shiny)
options(shiny.suppressMissingContextError = TRUE)

input <- list(x = 1)

y <- metaReactive({
  req(input$x)
  a <- ..(input$x) + 1
  b <- a + 1
  c + 1
})

withMetaMode(y())
expandChain(y())

y <- metaReactive2({
  req(input$x)

  metaExpr({
    a <- ..(input$x) + 1
    b <- a + 1
    c + 1
  }, bindToReturn = TRUE)
})

expandChain(y())

}
\seealso{
\code{\link[=metaExpr]{metaExpr()}}, \code{\link[=dotdot]{..}}
}
