% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{helper}
\alias{helper}
\title{Augment a shiny.tag with a question mark helper button}
\usage{
helper(shiny_tag, icon = "question-circle", colour = NULL,
  type = "markdown", title = "", content = "", size = "m", ...)
}
\arguments{
\item{shiny_tag}{A shiny element, such as an input or output (but any shiny tag will do).}

\item{icon}{A character string of the name of the icon to display (font awesome).}

\item{colour}{Any valid CSS colour for the icon.}

\item{type}{Either 'markdown' to include a helpfile, or 'inline' to specify text.}

\item{title}{The title to use for your modal. Leave as "" to have no title (for example,
if your markdown document has a header you wish to use instead).}

\item{content}{If \code{type = "markdown"}, the name of your markdown file; if
\code{type = "inline"}, a character vector of text/HTML to include. This will be pasted 
together with line breaks. You need not add '.md' to the markdown filename.}

\item{size}{Either 's', 'm' or 'l' - the size of the modal dialog to display.}

\item{...}{Other arguments to pass to the \code{div} containing the icon.}
}
\description{
Add an action button to your shiny UI with a question mark help icon (by default).
In combination with \code{\link{observe_helpers}} this icon will produce a modal
dialog box in the app, with content and title as specified. You may pass inline content
for the modal, or else specify the name of a markdown file to include.
}
\examples{
helper(shiny::actionButton("go", "click me!"),
       icon = "exclamation",
       colour = "red",
       type = "markdown",
       content = "ClickHelp")  # looks for 'helpfiles/ClickHelp.md'
       
}
