% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/for-shiny.R
\name{observe_helpers}
\alias{observe_helpers}
\title{Function to go in server.R to use the help messages}
\usage{
observe_helpers(input, output, help_dir = "helpfiles", sizes = "m",
  default_size = "m")
}
\arguments{
\item{input}{The input object in your shiny app}

\item{output}{The output object in your shiny app}

\item{help_dir}{A character string of the directory containing your helpfiles}

\item{sizes}{An optional named list of sizes for the input/output ids}

\item{default_size}{A default size to be passed to show_help_message, one of "s", "m", "l"}
}
\description{
Function to go in server.R to use the help messages
}
\examples{
server <- function(input, output, session){

  # use anywhere in your server.R script
  observe_helpers(input, output, sizes = list(xcol = "s", plot1 = "l"))
  
  # rest of server.R
  # ...
  # ...
}
}
