% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sweetalert.R
\name{show_toast}
\alias{show_toast}
\title{Show a toast notification}
\usage{
show_toast(
  title,
  text = NULL,
  type = c("default", "success", "error", "info", "warning", "question"),
  timer = 3000,
  timerProgressBar = TRUE,
  position = c("bottom-end", "top", "top-start", "top-end", "center", "center-start",
    "center-end", "bottom", "bottom-start"),
  width = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{title}{Title for the toast.}

\item{text}{Text for the toast.}

\item{type}{Type of the toast: \code{"default"},
\code{"success"}, \code{"error"}, \code{"info"},
\code{"warning"} or \code{"question"}.}

\item{timer}{Auto close timer of the modal. Set in ms (milliseconds).}

\item{timerProgressBar}{If set to true, the timer will have a progress bar at the bottom of a popup.}

\item{position}{Modal window position, can be \code{"top"}, \code{"top-start"},
\code{"top-end"}, \code{"center"}, \code{"center-start"}, \code{"center-end"},
\code{"bottom"}, \code{"bottom-start"}, or \code{"bottom-end"}.}

\item{width}{Modal window width, including paddings.}

\item{session}{The \code{session} object passed to function given to shinyServer.}
}
\value{
No value.
}
\description{
Show a toast notification
}
\examples{

library(shiny)
library(shinyWidgets)

ui <- fluidPage(
  tags$h2("Sweet Alert Toast"),
  actionButton(
    inputId = "toast",
    label = "Show default toast"
  ),
  actionButton(
    inputId = "success",
    label = "Show success toast",
    icon = icon("check")
  ),
  actionButton(
    inputId = "error",
    label = "Show error toast",
    icon = icon("remove")
  ),
  actionButton(
    inputId = "warning",
    label = "Show warning toast",
    icon = icon("exclamation-triangle")
  ),
  actionButton(
    inputId = "info",
    label = "Show info toast",
    icon = icon("info")
  )
)

server <- function(input, output, session) {

  observeEvent(input$toast, {
    show_toast(
      title = "Notification",
      text = "An imortant message"
    )
  })

  observeEvent(input$success, {
    show_toast(
      title = "Bravo",
      text = "Well done!",
      type = "success"
    )
  })

  observeEvent(input$error, {
    show_toast(
      title = "Ooops",
      text = "It's broken",
      type = "error",
      width = "800px",
      position = "bottom"
    )
  })

  observeEvent(input$warning, {
    show_toast(
      title = "Careful!",
      text = "Almost broken",
      type = "warning",
      position = "top-end"
    )
  })

  observeEvent(input$info, {
    show_toast(
      title = "Heads up",
      text = "Just a message",
      type = "info",
      position = "top-end"
    )
  })
}

if (interactive())
  shinyApp(ui, server)
}
\seealso{
\code{\link{show_alert}}, \code{\link{ask_confirmation}},
 \code{\link{closeSweetAlert}}.
}
