% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vertical-tab.R
\name{appendVerticalTab}
\alias{appendVerticalTab}
\alias{removeVerticalTab}
\alias{reorderVerticalTabs}
\title{Mutate Vertical Tabset Panel}
\usage{
appendVerticalTab(inputId, tab,
  session = shiny::getDefaultReactiveDomain())

removeVerticalTab(inputId, index,
  session = shiny::getDefaultReactiveDomain())

reorderVerticalTabs(inputId, newOrder,
  session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{inputId}{The id of the \code{verticalTabsetPanel} object.}

\item{tab}{The verticalTab to append.}

\item{session}{The \code{session} object passed to function given to \code{shinyServer.}}

\item{index}{The index of the the tab to remove.}

\item{newOrder}{The new index order.}
}
\description{
Mutate Vertical Tabset Panel
}
\examples{
if (interactive()) {
library(shiny)
library(shinyWidgets)

ui <- fluidPage(

  verticalTabsetPanel(
    verticalTabPanel("blaa","foo"),
    verticalTabPanel("yarp","bar"),
    id="hippi"
  )
)

server <- function(input, output, session) {
  appendVerticalTab("hippi", verticalTabPanel("bipi","long"))
  removeVerticalTab("hippi", 1)
  appendVerticalTab("hippi", verticalTabPanel("howdy","fair"))
  reorderVerticalTabs("hippi", c(3,2,1))
}

# Run the application
shinyApp(ui = ui, server = server)
}
}
