% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-awesomeradio.R
\name{awesomeRadio}
\alias{awesomeRadio}
\title{Awesome Radio Buttons Input Control}
\usage{
awesomeRadio(inputId, label, choices, selected = NULL, inline = FALSE,
  status = "primary", checkbox = FALSE)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{Input label.}

\item{choices}{List of values to select from (if elements of the list are named then that name rather than the value is displayed to the user)}

\item{selected}{The initially selected value}

\item{inline}{If TRUE, render the choices inline (i.e. horizontally)}

\item{status}{Color of the buttons, a valid Bootstrap status : default, primary, info, success, warning, danger.}

\item{checkbox}{Logical, render radio like checkboxes}
}
\value{
A set of radio buttons that can be added to a UI definition.
}
\description{
Create a set of prettier radio buttons used to select an item from a list.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

ui <- fluidPage(
  awesomeRadio(inputId = "somevalue", choices = c("A", "B", "C")),
  verbatimTextOutput("value")
)
server <- function(input, output) {
  output$value <- renderText({ input$somevalue })
}
shinyApp(ui, server)
}

}
\seealso{
\code{\link{updateAwesomeRadio}}
}
