% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup.R
\name{setupStorage}
\alias{setupStorage}
\title{Set up inputs for storage}
\usage{
setupStorage(appId, inputs = TRUE)
}
\arguments{
\item{appId}{your desired application id}

\item{inputs}{choose whether to track all inputs or specific input variables}
}
\value{
Embed within a page storage that allows input changes to be saved without slowing down the shiny application
}
\description{
Set up the application and inputs to track and retrieve stores
}
\note{
the inputs argument may be a \code{TRUE} or \code{FALSE} or a list of input ids
}
\examples{
\donttest{
library(shiny)
library(shinyStorePlus)

# example 1 that tracks all inputs
if (interactive()) {
  ui <- shiny::fluidPage(
    titlePanel("EX1
             shinyStorePlus All Inputs"),
    initStore(),
    sidebarLayout(
      sidebarPanel(
        sliderInput("nextgenshinyapps1",
          "Number of bins:",
          min = 1,
          max = 200,
          value = 150
        ),
        textInput(
          "caption",
          "simple caption:",
          "try editing - r2resize pkg"
        ),
        numericInput("obs",
          "sample observations:",
          10,
          min = 1, max = 100
        )
      ),
      mainPanel(
        plotOutput("distPlot")
      )
    )
  )
  server <- function(input, output, session) {
    output$distPlot <- renderPlot({
      x <- faithful[, 2]
      bins <- seq(min(x),
        max(x),
        length.out =
          input$nextgenshinyapps1 + 1
      )
      hist(x,
        breaks = bins,
        col = "blue",
        border = "gray"
      )
    })

    # insert at the bottom
    appid <- "application01"
    setupStorage(
      appId = appid,
      inputs = TRUE
    )
  }
  shiny::shinyApp(ui = ui, server = server)
}


# example 2 that tracks only 2 inputs
if (interactive()) {
  ui <- shiny::fluidPage(
    # init stores
    initStore(),
    titlePanel("Ex2:
             shinyStorePlus Some Inputs"),
    sidebarLayout(
      sidebarPanel(
        sliderInput("nextgenshinyapps1",
          "Number of bins:",
          min = 1,
          max = 200,
          value = 150
        ),
        textInput(
          "caption",
          "simple caption:",
          "summary, try editing"
        ),
        numericInput("obs",
          "sample observations:",
          10,
          min = 1, max = 100
        )
      ),
      mainPanel(
        plotOutput("distPlot")
      )
    )
  )
  server <- function(input, output, session) {
    output$distPlot <- renderPlot({
      x <- faithful[, 2]
      bins <- seq(min(x),
        max(x),
        length.out =
          input$nextgenshinyapps1 + 1
      )
      hist(x,
        breaks = bins,
        col = "blue",
        border = "gray"
      )
    })

    # insert at the bottom  !!!IMPORTANT
    appid <- "application023"
    setupStorage(
      appId = appid,
      inputs = list(
        "nextgenshinyapps1",
        "caption"
      )
    )
  }
  shiny::shinyApp(ui = ui, server = server)
}
}

}
