% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/includes.R
\name{initStore}
\alias{initStore}
\title{Included package scripts}
\usage{
initStore()
}
\value{
Initialize the storage by including scripts necessary for the persistent storage handling
}
\description{
Include Dexie and the package script in the header
}
\examples{
\donttest{
library(shiny)
library(shinyStorePlus)

if (interactive()) {
  ui <- shiny::fluidPage(
    # initialize stores
    initStore(),
    titlePanel("Sample
             shinyStorePlus Init Inputs"),
    sidebarLayout(
      sidebarPanel(
        sliderInput("nextgenshinyapps1",
          "Number of bins:",
          min = 1,
          max = 200,
          value = 150
        ),
        textInput(
          "caption",
          "simple caption:",
          "summary, try editing"
        ),
        numericInput("obs",
          "sample observations:",
          10,
          min = 1, max = 100
        )
      ),
      mainPanel(
        plotOutput("distPlot")
      )
    )
  )
  server <- function(input, output, session) {
    output$distPlot <- renderPlot({
      x <- faithful[, 2]
      bins <- seq(min(x),
        max(x),
        length.out =
          input$nextgenshinyapps1 + 1
      )
      hist(x,
        breaks = bins,
        col = "blue",
        border = "gray"
      )
    })
  }
  shiny::shinyApp(ui = ui, server = server)
}
}

}
