% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods__userinfo.R
\name{get_userinfo}
\alias{get_userinfo}
\title{Get user info from OAuth 2.0 provider}
\usage{
get_userinfo(oauth_client, token)
}
\arguments{
\item{oauth_client}{\link{OAuthClient} object. The client must have a
\code{userinfo_url} configured in its \link{OAuthProvider}.}

\item{token}{Either an \link{OAuthToken} object or a raw access token string.}
}
\value{
A list containing the user information as returned by the provider.
}
\description{
Fetches user information from the provider's userinfo endpoint using the
provided access token. Emits an audit event with redacted details.
}
\examples{
# Please note: `get_userinfo()`, `introspect_token()`, and `refresh_token()`
# are typically not called by users of this package directly, but are called
# internally by `oauth_module_server()`. These functions are exported
# nonetheless for advanced use cases. Most users will not need to
# call these functions directly

# Example requires a real token from a completed OAuth flow
# (code is therefore not run; would error with placeholder values below)
\dontrun{
# Define client
client <- oauth_client(
  provider = oauth_provider_github(),
  client_id = Sys.getenv("GITHUB_OAUTH_CLIENT_ID"),
  client_secret = Sys.getenv("GITHUB_OAUTH_CLIENT_SECRET"),
  redirect_uri = "http://127.0.0.1:8100"
)

# Have a valid OAuthToken object; fake example below
# (typically provided by `oauth_module_server()` or `handle_callback()`)
token <- handle_callback(client, "<code>", "<payload>", "<browser_token>")

# Get userinfo
user_info <- get_userinfo(client, token)

# Introspect token (if supported by provider)
introspection <- introspect_token(client, token)

# Refresh token
new_token <- refresh_token(client, token, introspect = TRUE)
}
}
