% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renderCurves.R
\name{renderAmpCurves}
\alias{renderAmpCurves}
\title{Renders an amplification curves viewer}
\usage{
renderAmpCurves(inputId, label = NULL, ampCurves, colorBy = NULL,
  linetypeBy = NULL, logScale = FALSE, showCq = FALSE, showLegend = FALSE,
  thBy = NULL, plotlyCode = NULL, cssFile = NULL, cssText = NULL,
  interactive = TRUE)
}
\arguments{
\item{inputId}{The \code{input} slot that will be used to modify plot.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{ampCurves}{Amplification curves data with
\code{RDML$GetFData(long.table = TRUE)} format.}

\item{colorBy}{Column name that contains color levels data.}

\item{linetypeBy}{Column name that contains linetype levels data.}

\item{logScale}{Converts plot to \code{log(RFU)}.}

\item{showCq}{Shows Cq with dots (\code{cq} column have to be provided!).}

\item{showLegend}{Show plot legend.}

\item{thBy}{Column name that separates threshold values (\code{quantFluor}
column have to be provided!).}

\item{plotlyCode}{Your quoted custom plotly code.}

\item{cssFile}{Path to the css styles file.}

\item{cssText}{CSS styles as text.}

\item{interactive}{Should be this \code{pcrPlate} interactive or not.}
}
\description{
Renders a reactive PCR amplification plot that is suitable for assigning to
an \code{UI output} slot.
}
\examples{
library(RDML)
rdml <- RDML$new(system.file("/extdata/test.rdml", package = "shinyMolBio"))
curves <- renderAmpCurves("curves1", ampCurves = rdml$GetFData(long.table = TRUE))
curves[[2]][[3]][[2]]
}
\seealso{
\code{\link{updateCurves}}

Other render elements: \code{\link{renderMeltCurves}}
}
\author{
Konstantin A. Blagodatskikh <k.blag@yandex.ru>
}
\concept{render elements}
\keyword{Input}
\keyword{PCR}
\keyword{RDML}
\keyword{Shiny}
