% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-tabs.R
\name{updateF7Tabs}
\alias{updateF7Tabs}
\title{Update a Framework 7 tabsetPanel}
\usage{
updateF7Tabs(id, selected = NULL, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{id}{Id of the \link{f7Tabs} to update.}

\item{selected}{Newly selected tab.}

\item{session}{Shiny session object.}
}
\description{
Update \link{f7Tabs}.
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)

 subtabs_ui <- function(id) {
   ns <- NS(id)

   tagList(
     f7Toggle(inputId = ns("updateSubTab"), label = "Update SubTab", checked = FALSE),
     f7Tabs(
       id = ns("subtabdemo"),
       style = "strong",
       animated = FALSE,
       f7Tab(title = "Subtab 1", tabName = "SubTab1", "SubTab 1"),
       f7Tab(title = "Subtab 2", tabName = "SubTab2", "SubTab 2", active = TRUE),
       f7Tab(title = "Subtab 3", tabName = "SubTab3", "SubTab 3")
     )
   )
 }

 subtabs <- function(input, output, session) {
   observeEvent(input$updateSubTab, {
     selected <- ifelse(input$updateSubTab, "SubTab1", "SubTab2")
     updateF7Tabs(session, id = "subtabdemo", selected = selected)
   })
   return(reactive(input$subtabdemo))
 }

 shinyApp(
   ui = f7Page(
     title = "Tab Layout",
     f7TabLayout(
       navbar = f7Navbar(
         title =
           f7Flex(
             HTML(paste("Selected Tab:", textOutput("selectedTab"))),
             HTML(paste("Selected Subtab:", textOutput("selectedSubTab")))
           )
         ,
         subNavbar = f7SubNavbar(
           f7Flex(
             f7Toggle(inputId = "updateTab", label = "Update Tab", checked = TRUE),
             subtabs_ui("subtabs1")[[1]]
           )
         )
       ),
       f7Tabs(
         id = "tabdemo",
         swipeable = TRUE,
         animated = FALSE,
         f7Tab(
           title = "Tab 1",
           tabName = "Tab1",
           subtabs_ui("subtabs1")[[2]]
         ),
         f7Tab(title = "Tab 2", tabName = "Tab2", "Tab 2"),
         f7Tab(title = "Tab 3", tabName = "Tab3", "Tab 3")
       )
     )
   ),
   server = function(input, output, session) {
     output$selectedTab <- renderText(input$tabdemo)
     observeEvent(input$updateTab, {
       selected <- ifelse(input$updateTab, "Tab1", "Tab2")
       updateF7Tabs(id = "tabdemo", selected = selected)
     })
     subtab <- callModule(subtabs, "subtabs1")
     output$selectedSubTab <- renderText(subtab())
   }
 )
 # with hidden tabs
 shinyApp(
  ui <- f7Page(
    title = "shinyMobile",
    f7TabLayout(
      navbar = f7Navbar(
        title = "Update Tabs with hidden tab",
        subtitle = "",
        hairline = TRUE,
        shadow = TRUE,
        bigger = FALSE,
        transparent = TRUE
      ),
      f7Tabs(
        id = 'tabs',
        animated = TRUE,
        f7Tab(
          active = TRUE,
          title = "Main tab",
          tabName = "Tab1",
          icon = f7Icon("doc_text"),
          h1("This is the first tab."),
          f7Button(inputId = "goto", label = "Go to hidden tab")
        ),
        f7Tab(
          title = "Second tab",
          tabName = "Tab2",
          icon = f7Icon("bolt_horizontal"),
          h1("This is the second tab.")
        ),
        f7Tab(
          title = "Hidden tab",
          tabName = "Tab3",
          hidden = TRUE,
          h1("This is a tab that does not appear in the tab menu.
          Yet, you can still access it.")
        )
      )
    )
  ),
  server = function(input, output, session) {
    observe(print(input$tabs))
    observeEvent(input$goto, {
      updateF7Tabs(session = session, id = "tabs", selected = "Tab3")
    })
  }
 )
}
}
