% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7List.R
\name{f7VirtualList}
\alias{f7VirtualList}
\alias{f7VirtualListItem}
\title{Framework7 virtual list}
\usage{
f7VirtualList(id, items, rowsBefore = NULL, rowsAfter = NULL, cache = TRUE)

f7VirtualListItem(
  ...,
  title = NULL,
  subtitle = NULL,
  header = NULL,
  footer = NULL,
  href = NULL,
  media = NULL,
  right = NULL
)
}
\arguments{
\item{id}{Virtual list unique id.}

\item{items}{List items. Slot for \link{f7VirtualListItem}.}

\item{rowsBefore}{Amount of rows (items) to be rendered before current
screen scroll position. By default it is equal to double amount of
rows (items) that fit to screen.}

\item{rowsAfter}{Amount of rows (items) to be rendered after current
screen scroll position. By default it is equal to the amount of rows
(items) that fit to screen.}

\item{cache}{Disable or enable DOM cache for already rendered list items.
In this case each item will be rendered only once and all further
manipulations will be with DOM element. It is useful if your list
items have some user interaction elements (like form elements or swipe outs)
or could be modified.}

\item{...}{Item text.}

\item{title}{Item title.}

\item{subtitle}{Item subtitle.}

\item{header}{Item header. Do not use when \link{f7List} mode is not NULL.}

\item{footer}{Item footer. Do not use when \link{f7List} mode is not NULL.}

\item{href}{Item external link.}

\item{media}{Expect \link{f7Icon} or \code{img}.}

\item{right}{Right content if any.}
}
\description{
\link{f7VirtualList} is a high performance list container.
Use if you have too many components in \link{f7List}.

\link{f7VirtualListItem} is an item component for \link{f7VirtualList}.
}
\examples{
if (interactive()) {
 library(shiny)
 library(shinyMobile)
 shinyApp(
  ui = f7Page(
    title = "Virtual List",
    f7SingleLayout(
      navbar = f7Navbar(
        title = "Virtual Lists",
        hairline = FALSE,
        shadow = TRUE
      ),
      # main content
      f7VirtualList(
        id = "vlist",
        rowsBefore = 2,
        rowsAfter = 2,
        items = lapply(1:20000, function(i) {
          f7VirtualListItem(
            title = paste("Title", i),
            subtitle = paste("Subtitle", i),
            header = paste("Header", i),
            footer = paste("Footer", i),
            right = paste("Right", i),
            content = i,
            media = img(src = "https://cdn.framework7.io/placeholder/fashion-88x88-1.jpg")
          )
        })
      )
    )
  ),
  server = function(input, output) {

  }
 )

 # below example will not load with classic f7List
 shinyApp(
   ui = f7Page(
     title = "My app",
     f7SingleLayout(
       navbar = f7Navbar(
         title = "Virtual Lists",
         hairline = FALSE,
         shadow = TRUE
       ),
       # main content
       f7List(
         lapply(1:20000, function(i) {
           f7ListItem(
             title = paste("Title", i),
             subtitle = paste("Subtitle", i),
             header = paste("Header", i),
             footer = paste("Footer", i),
             right = paste("Right", i),
             content = i
           )
         })
       )
     )
   ),
   server = function(input, output) {

   }
 )
}
}
