% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Timeline.R
\name{f7Timeline}
\alias{f7Timeline}
\alias{f7TimelineItem}
\title{Framework7 timeline}
\usage{
f7Timeline(
  ...,
  sides = FALSE,
  horizontal = FALSE,
  calendar = FALSE,
  year = NULL,
  month = NULL
)

f7TimelineItem(
  ...,
  date = NULL,
  card = FALSE,
  time = NULL,
  title = NULL,
  subtitle = NULL,
  side = NULL
)
}
\arguments{
\item{...}{Item content, text for instance.}

\item{sides}{Enable side-by-side timeline mode.}

\item{horizontal}{Whether to use the horizontal layout. Not compatible with sides.}

\item{calendar}{Special type of horizontal layout with current year and month.}

\item{year}{Current year, only if calendar is TRUE.}

\item{month}{Current month, only if calendar is TRUE.}

\item{date}{Timeline item date. Required.}

\item{card}{Whether to wrap the content in a card. FALSE by default.}

\item{time}{Timeline item time. Optional.}

\item{title}{Timeline item title. Optional.}

\item{subtitle}{Timeline item subtitle. Optional.}

\item{side}{Force element to required side: "right" or "left". Only if sides os TRUE in \link{f7Timeline}}
}
\description{
\link{f7Timeline} is a static timeline container.

\link{f7TimelineItem} goes inside \link{f7Timeline}.
}
\examples{
if(interactive()){
 library(shiny)
 library(shinyMobile)

 items <- tagList(
   f7TimelineItem(
     "Another text",
     date = "01 Dec",
     card = FALSE,
     time = "12:30",
     title = "Title",
     subtitle = "Subtitle",
     side = "left"
   ),
   f7TimelineItem(
     "Another text",
     date = "02 Dec",
     card = TRUE,
     time = "13:00",
     title = "Title",
     subtitle = "Subtitle"
   ),
   f7TimelineItem(
     "Another text",
     date = "03 Dec",
     card = FALSE,
     time = "14:45",
     title = "Title",
     subtitle = "Subtitle"
   )
 )

 shinyApp(
   ui = f7Page(
     title = "Timelines",
     f7SingleLayout(
       navbar = f7Navbar(title = "Timelines"),
       f7BlockTitle(title = "Horizontal timeline", size = "large") \%>\%
       f7Align(side = "center"),
       f7Timeline(
         sides = FALSE,
         horizontal = TRUE,
         items
       ),
       f7BlockTitle(title = "Vertical side by side timeline", size = "large") \%>\%
       f7Align(side = "center"),
       f7Timeline(
         sides = TRUE,
         items
       ),
       f7BlockTitle(title = "Vertical timeline", size = "large") \%>\%
       f7Align(side = "center"),
       f7Timeline(items),
       f7BlockTitle(title = "Calendar timeline", size = "large") \%>\%
       f7Align(side = "center"),
       f7Timeline(items, calendar = TRUE, year = "2019", month = "December")
     )
   ),
   server = function(input, output) {}
 )
}

}
\author{
David Granjon \email{dgranjon@ymail.com}

David Granjon \email{dgranjon@ymail.com}
}
