% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7-inputs.R
\name{f7Text}
\alias{f7Text}
\alias{updateF7Text}
\title{Framework7 text input}
\usage{
f7Text(inputId, label, value = "", placeholder = NULL)

updateF7Text(
  inputId,
  label = NULL,
  value = NULL,
  placeholder = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{inputId}{The id of the input object.}

\item{label}{The label to set for the input object.}

\item{value}{The value to set for the input object.}

\item{placeholder}{The placeholder to set for the input object.}

\item{session}{The Shiny session object, usually the default value will suffice.}
}
\description{
\link{f7Text} creates a text input container.

\link{updateF7Text} changes the value of a text input on the client.
}
\examples{
# A text input
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shinyApp(
   ui = f7Page(
     title = "My app",
     f7SingleLayout(
      navbar = f7Navbar(title = "f7Text"),
      f7Text(
       inputId = "caption",
       label = "Caption",
       value = "Data Summary",
       placeholder = "Your text here"
      ),
      verbatimTextOutput("value")
     )
   ),
   server = function(input, output) {
     output$value <- renderPrint({ input$caption })
   }
 )
}
# Update text input
if (interactive()) {
 library(shiny)
 library(shinyMobile)

 ui <- f7Page(
   f7SingleLayout(
    navbar = f7Navbar(title = "updateF7Text"),
    f7Block(f7Button("trigger", "Click me")),
    f7Text(
     inputId = "text",
     label = "Caption",
     value = "Some text",
     placeholder = "Your text here"
    ),
    verbatimTextOutput("value")
   )
 )

 server <- function(input, output, session) {
   output$value <- renderPrint(input$text)
   observeEvent(input$trigger, {
     updateF7Text("text", value = "Updated Text")
   })
 }
shinyApp(ui, server)
}
}
