% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f7Card.R
\name{f7ExpandableCard}
\alias{f7ExpandableCard}
\title{Create a Framework7 expandable card}
\usage{
f7ExpandableCard(
  ...,
  id = NULL,
  title = NULL,
  subtitle = NULL,
  color = NULL,
  img = NULL,
  fullBackground = FALSE
)
}
\arguments{
\item{...}{Card content.}

\item{id}{Unique card id. Useful to handle multiple cards in the DOM.}

\item{title}{Card title.}

\item{subtitle}{Card subtitle.}

\item{color}{Card background color. See \url{http://framework7.io/docs/cards.html}.
Not compatible with the img argument.}

\item{img}{Card background image url. Tje JPG format is prefered. Not compatible
with the color argument.}

\item{fullBackground}{Whether the image should cover the entire card.}
}
\description{
Build a Framework7 expandable card
}
\note{
img and color are not compatible. Choose one of them.
}
\examples{
if(interactive()){
 library(shiny)
 library(shinyMobile)

 shiny::shinyApp(
  ui = f7Page(
    title = "Expandable Cards",
    f7SingleLayout(
      navbar = f7Navbar(
       title = "Expandable Cards",
       hairline = FALSE,
       shadow = TRUE
      ),
      f7ExpandableCard(
       id = "card1",
       title = "Expandable Card 1",
       color = "blue",
       subtitle = "Click on me pleaaaaase",
       "Framework7 - is a free and open source HTML mobile framework
       to develop hybrid mobile apps or web apps with iOS or Android
       native look and feel. It is also an indispensable prototyping apps tool
       to show working app prototype as soon as possible in case you need to."
      ),
      f7ExpandableCard(
       id = "card2",
       title = "Expandable Card 2",
       color = "green",
       "Framework7 - is a free and open source HTML mobile framework
       to develop hybrid mobile apps or web apps with iOS or Android
       native look and feel. It is also an indispensable prototyping apps tool
       to show working app prototype as soon as possible in case you need to."
      ),
      f7ExpandableCard(
       id = "card3",
       title = "Expandable Card 3",
       img = "https://i.pinimg.com/originals/73/38/6e/73386e0513d4c02a4fbb814cadfba655.jpg",
       "Framework7 - is a free and open source HTML mobile framework
        to develop hybrid mobile apps or web apps with iOS or Android
        native look and feel. It is also an indispensable prototyping apps tool
        to show working app prototype as soon as possible in case you need to."
      ),
      f7ExpandableCard(
       id = "card4",
       title = "Expandable Card 4",
       fullBackground = TRUE,
       img = "https://i.ytimg.com/vi/8q_kmxwK5Rg/maxresdefault.jpg",
       "Framework7 - is a free and open source HTML mobile framework
              to develop hybrid mobile apps or web apps with iOS or Android
              native look and feel. It is also an indispensable prototyping apps tool
              to show working app prototype as soon as possible in case you need to."
      )
    )
  ),
  server = function(input, output) {}
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
