% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noti_banner.R
\name{noti_banner}
\alias{noti_banner}
\title{Notification Banner Function}
\usage{
noti_banner(
  inputId,
  title_txt = "Important",
  body_txt = NULL,
  type = "standard"
)
}
\arguments{
\item{inputId}{The input id for the banner}

\item{title_txt}{The wording that appears in the title}

\item{body_txt}{The wording that appears in the banner body}

\item{type}{The type of banner.  Options are standard and success.
Standard is default}
}
\value{
a notification html shiny object
}
\description{
This function create a notification banner
}
\examples{
if (interactive()) {

  ui <- fluidPage(
    shinyGovstyle::header(
      main_text = "Example",
      secondary_text = "User Examples",
      logo="shinyGovstyle/images/moj_logo.png"),
    shinyGovstyle::noti_banner(
      inputId = "banner", title_txt = "Important", body_txt = "Example text")
  )

  server <- function(input, output, session) {}

  shinyApp(ui = ui, server = server)
}

}
\keyword{banner}
\keyword{notification}
