% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_logging.R
\name{set_logging}
\alias{set_logging}
\title{Settings for event logging}
\usage{
set_logging(r_console = TRUE, js_console = TRUE, file = FALSE,
  database = FALSE, ...)
}
\arguments{
\item{r_console}{A logical. Should events be logged into R console?
Default is \code{TRUE}.}

\item{js_console}{A logical. Should events be logged into browser
JavaScript console? Default is \code{TRUE}.}

\item{file}{A logical or a character string.
Should events be logged to a file?
Default is \code{FALSE}.
If \code{TRUE} the default eventlog filename is \code{"events.log"}.
If character string, path and name of the filelog.}

\item{database}{A logical or a character string.
Should events be logged into a database?
  Default is \code{FALSE}.
  If \code{TRUE} or \code{"mongoDB"} the connection URL to the database
  will be read from the first line of a text file named \code{".db_url"}.}

\item{...}{a set of named objects
 (usually of type character, numeric, or date)
to be logged as parameters common to all events.}
}
\description{
\code{set_logging} should be used outside ui and server functions,
possibly in \code{global.R}, to be used only once to define
where the logging should be done.
Events can be sent to R console, browser JavaScript console,
a eventlog file, or a database (or any combination of these).
By default logging is done to the R console and JavaScript console.
\code{set_logging} also can be used
to define global event parameters - named objects passed to \code{...}
that will be evaluated and added to lists of parameters of all events.
}
\details{
\code{set_logging} assigns to the parent frame a new environment
\code{log_settings_global} for storing global event parameters.
If \code{database = TRUE} additional database connection object
named \code{log_db} is assigned to the parent frame as well.
}
\examples{
if (interactive()) {

  set_logging(r_console = TRUE,
              js_console = FALSE,
              "param_1" = 1,
              "param_2" = "A")

  shiny::shinyApp(
    ui = shiny::fluidPage(),
    server = function(input, output) {
      set_logging_session()
      log_event("Event with global params")
    }
  )
}
}
\seealso{
Other setting up logging parameters functions: \code{\link{log_params}},
  \code{\link{set_logging_session}}
}
\concept{setting up logging parameters functions}
