% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinywrappers.R
\name{renderPrint}
\alias{renderPrint}
\alias{renderText}
\title{Text Output}
\usage{
renderPrint(
  expr,
  env = parent.frame(),
  quoted = FALSE,
  width = getOption("width"),
  outputArgs = list()
)

renderText(
  expr,
  env = parent.frame(),
  quoted = FALSE,
  outputArgs = list(),
  sep = " "
)
}
\arguments{
\item{expr}{An expression to evaluate.}

\item{env}{The parent environment for the reactive expression. By default,
this is the calling environment, the same as when defining an ordinary
non-reactive expression. If \code{expr} is a quosure and \code{quoted} is \code{TRUE},
then \code{env} is ignored.}

\item{quoted}{If it is \code{TRUE}, then the \code{\link[=quote]{quote()}}ed value of \code{expr}
will be used when \code{expr} is evaluated. If \code{expr} is a quosure and you
would like to use its expression as a value for \code{expr}, then you must set
\code{quoted} to \code{TRUE}.}

\item{width}{Width of printed output.}

\item{outputArgs}{A list of arguments to be passed through to the implicit
call to \code{\link[=verbatimTextOutput]{verbatimTextOutput()}} or \code{\link[=textOutput]{textOutput()}} when the functions are
used in an interactive RMarkdown document.}

\item{sep}{A separator passed to \code{cat} to be appended after each
element.}
}
\value{
For \code{renderPrint()}, note the given expression returns \code{NULL} then \code{NULL}
will actually be visible in the output. To display nothing, make your
function return \code{\link[=invisible]{invisible()}}.
}
\description{
\code{renderPrint()} prints the result of \code{expr}, while \code{renderText()} pastes it
together into a single string. \code{renderPrint()} is equivalent to \code{\link[=print]{print()}};
\code{renderText()} is equivalent to \code{\link[=cat]{cat()}}. Both functions capture all other
printed output generated while evaluating \code{expr}.

\code{renderPrint()} is usually paired with \code{\link[=verbatimTextOutput]{verbatimTextOutput()}};
\code{renderText()} is usually paired with \code{\link[=textOutput]{textOutput()}}.
}
\details{
The corresponding HTML output tag can be anything (though \code{pre} is
recommended if you need a monospace font and whitespace preserved) and should
have the CSS class name \code{shiny-text-output}.
}
\examples{
isolate({

# renderPrint captures any print output, converts it to a string, and
# returns it
visFun <- renderPrint({ "foo" })
visFun()
# '[1] "foo"'

invisFun <- renderPrint({ invisible("foo") })
invisFun()
# ''

multiprintFun <- renderPrint({
  print("foo");
  "bar"
})
multiprintFun()
# '[1] "foo"\n[1] "bar"'

nullFun <- renderPrint({ NULL })
nullFun()
# 'NULL'

invisNullFun <- renderPrint({ invisible(NULL) })
invisNullFun()
# ''

vecFun <- renderPrint({ 1:5 })
vecFun()
# '[1] 1 2 3 4 5'


# Contrast with renderText, which takes the value returned from the function
# and uses cat() to convert it to a string
visFun <- renderText({ "foo" })
visFun()
# 'foo'

invisFun <- renderText({ invisible("foo") })
invisFun()
# 'foo'

multiprintFun <- renderText({
  print("foo");
  "bar"
})
multiprintFun()
# 'bar'

nullFun <- renderText({ NULL })
nullFun()
# ''

invisNullFun <- renderText({ invisible(NULL) })
invisNullFun()
# ''

vecFun <- renderText({ 1:5 })
vecFun()
# '1 2 3 4 5'

})
}
\seealso{
\code{\link[=outputOptions]{outputOptions()}}
}
