% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/run-url.R
\name{runUrl}
\alias{runGist}
\alias{runGitHub}
\alias{runUrl}
\title{Run a Shiny application from a URL}
\usage{
runUrl(url, filetype = NULL, subdir = NULL, ...)

runGist(gist, ...)

runGitHub(repo, username = getOption("github.user"), ref = "master",
  subdir = NULL, ...)
}
\arguments{
\item{url}{URL of the application.}

\item{filetype}{The file type (\code{".zip"}, \code{".tar"}, or
\code{".tar.gz"}. Defaults to the file extension taken from the url.}

\item{subdir}{A subdirectory in the repository that contains the app. By
default, this function will run an app from the top level of the repo, but
you can use a path such as `\code{"inst/shinyapp"}.}

\item{...}{Other arguments to be passed to \code{\link{runApp}()}, such as
\code{port} and \code{launch.browser}.}

\item{gist}{The identifier of the gist. For example, if the gist is
https://gist.github.com/jcheng5/3239667, then \code{3239667},
\code{'3239667'}, and \code{'https://gist.github.com/jcheng5/3239667'} are
all valid values.}

\item{repo}{Name of the repository.}

\item{username}{GitHub username. If \code{repo} is of the form
\code{"username/repo"}, \code{username} will be taken from \code{repo}.}

\item{ref}{Desired git reference. Could be a commit, tag, or branch name.
Defaults to \code{"master"}.}
}
\description{
\code{runUrl()} downloads and launches a Shiny application that is hosted at
a downloadable URL. The Shiny application must be saved in a .zip, .tar, or
.tar.gz file. The Shiny application files must be contained in the root
directory or a subdirectory in the archive. For example, the files might be
\code{myapp/server.r} and \code{myapp/ui.r}. The functions \code{runGitHub()}
and \code{runGist()} are based on \code{runUrl()}, using URL's from GitHub
(\url{https://github.com}) and GitHub gists (\url{https://gist.github.com}),
respectively.
}
\examples{
## Only run this example in interactive R sessions
  if (interactive()) {
  runUrl('https://github.com/rstudio/shiny_example/archive/master.tar.gz')

  # Can run an app from a subdirectory in the archive
  runUrl("https://github.com/rstudio/shiny_example/archive/master.zip",
    subdir = "inst/shinyapp/")
}
## Only run this example in interactive R sessions
if (interactive()) {
  runGist(3239667)
  runGist("https://gist.github.com/jcheng5/3239667")

  # Old URL format without username
  runGist("https://gist.github.com/3239667")
}
## Only run this example in interactive R sessions
if (interactive()) {
  runGitHub("shiny_example", "rstudio")
  # or runGitHub("rstudio/shiny_example")

  # Can run an app from a subdirectory in the repo
  runGitHub("shiny_example", "rstudio", subdir = "inst/shinyapp/")
}
}

