% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input.R
\name{text_input}
\alias{text_input}
\alias{textInput}
\title{Create Semantic UI Text Input}
\usage{
text_input(
  input_id,
  label = NULL,
  value = "",
  type = "text",
  placeholder = NULL,
  attribs = list()
)

textInput(
  inputId,
  label,
  value = "",
  width = NULL,
  placeholder = NULL,
  type = "text"
)
}
\arguments{
\item{input_id}{Input name. Reactive value is available under \code{input[[input_id]]}.}

\item{label}{character with label put on the left from the input}

\item{value}{Pass value if you want to have default text.}

\item{type}{Change depending what type of input is wanted. See details for options.}

\item{placeholder}{Text visible in the input when nothing is inputted.}

\item{attribs}{A named list of attributes to assign to the input.}

\item{inputId}{Input name. The same as \code{input_id}.}

\item{width}{The width of the input, eg. "40px"}
}
\description{
This creates a default text input using Semantic UI. The input is available
under \code{input[[input_id]]}.
}
\details{
The following \code{type} s are allowed:
\itemize{
\item{text} {The standard input}
\item{textarea} {An extended space for text}
\item{password} {A censored version of the text input}
\item{email} {A special version of the text input specific for email addresses}
\item{url} {A special version of the text input specific for URLs}
\item{tel} {A special version of the text input specific for telephone numbers}
}

The inputs are updateable by using \code{\link[shiny]{updateTextInput}} or
\code{\link[shiny]{updateTextAreaInput}} if \code{type = "textarea"}.
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {
  library(shiny)
  library(shiny.semantic)
  ui <- semanticPage(
    uiinput(
      text_input("ex", label = "Your text", type = "text", placeholder = "Enter Text")
    )
  )
  server <- function(input, output, session) {
 }
 shinyApp(ui, server)
 }
}
