% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input.R
\name{uitextinput}
\alias{uitextinput}
\title{Create Semantic UI Text Input}
\usage{
uitextinput(
  name,
  value = "",
  type = "text",
  placeholder = NULL,
  attribs = list()
)
}
\arguments{
\item{name}{Input name. Reactive value is available under \code{input[[name]]}.}

\item{value}{Pass value if you want to have default text.}

\item{type}{Change depending what type of input is wanted. See details for options.}

\item{placeholder}{Text visible in the input when nothing is inputted.}

\item{attribs}{A named list of attributes to assign to the input.}
}
\description{
This creates a default text input using Semantic UI. The input is available
under \code{input[[name]]}.
}
\details{
The following \code{type}s are allowed:
\itemize{
\item{text}{The standard input}
\item{textarea}{An extended space for text}
\item{password}{A censored version of the text input}
\item{email}{A special version of the text input specific for email addresses}
\item{url}{A special version of the text input specific for URLs}
\item{tel}{A special version of the text input specific for telephone numbers}
}

The inputs are updateable by using \code{\link[shiny]{updateTextInput}} or
\code{\link[shiny]{updateTextAreaInput}} if \code{type = "textarea"}.
}
\examples{
library(shiny)
library(shiny.semantic)

# Text input
uiinput(
  tags$label("Text input"),
  uitextinput("ex", type = "text", placeholder = "Enter Text")
)

}
