% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration.R
\name{AggregatedEffects}
\alias{AggregatedEffects}
\title{Summarised coefficients conditionally on selection}
\usage{
AggregatedEffects(
  stability,
  lambda_id = NULL,
  side = "X",
  comp = 1,
  FUN = stats::median,
  ...
)
}
\arguments{
\item{stability}{output of \code{\link{VariableSelection}} or
\code{\link{BiSelection}}.}

\item{lambda_id}{parameter ID with respect to the grid \code{Lambda}. If
\code{NULL}, aggregated coefficients across the models run with the
calibrated parameter are returned.}

\item{side}{character string indicating if coefficients of predictors
(\code{side="X"}) or outcomes (\code{side="Y"}) should be returned. Only
applicable to PLS models.}

\item{comp}{component ID. Only applicable to PLS models.}

\item{FUN}{function to use to aggregate coefficients of visited models over
resampling iterations. Recommended functions include
\code{\link[stats]{median}} or \code{\link[base]{mean}}.}

\item{...}{additional arguments to be passed to \code{FUN}.}
}
\value{
A matrix of summarised coefficients conditionally on selection across
  resampling iterations. Missing values (\code{NA}) are returned for
  variables that are never selected.
}
\description{
Computes descriptive statistics (defined by \code{FUN}) for coefficients of
the (calibrated) models conditionally on selection across resampling
iterations.
}
\examples{
\donttest{
# Example with univariate outcome
set.seed(1)
simul <- SimulateRegression(n = 100, pk = 50, family = "gaussian")
stab <- VariableSelection(xdata = simul$xdata, ydata = simul$ydata, family = "gaussian")
median_betas <- AggregatedEffects(stab)

# Comparison with refitted model
refitted <- Refit(xdata = simul$xdata, ydata = simul$ydata, stability = stab)
refitted_betas <- refitted$coefficients[-1]
plot(median_betas[names(refitted_betas), ], refitted_betas,
  panel.first = abline(0, 1, lty = 2)
)

# Extracting mean betas conditionally on selection
mean_betas <- AggregatedEffects(stab, FUN = mean)
plot(median_betas, mean_betas)

# Regression with multivariate outcomes
set.seed(1)
simul <- SimulateRegression(n = 100, pk = 50, q = 2, family = "gaussian")
stab <- VariableSelection(xdata = simul$xdata, ydata = simul$ydata, family = "mgaussian")
median_betas <- AggregatedEffects(stab)
dim(median_betas)

# Sparse PLS with multivariate outcome
set.seed(1)
simul <- SimulateRegression(n = 50, pk = 15, q = 3, family = "gaussian")
x <- simul$xdata
y <- simul$ydata
stab <- BiSelection(
  xdata = x, ydata = y,
  family = "gaussian", ncomp = 3,
  LambdaX = 1:(ncol(x) - 1),
  implementation = SparsePLS
)
median_betas <- AggregatedEffects(stab)
dim(median_betas)
median_betas <- AggregatedEffects(stab, side = "Y")
dim(median_betas)
}

}
\seealso{
\code{\link{VariableSelection}}, \code{\link{BiSelection}},
  \code{\link{Refit}}
}
