% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default.mass.R
\name{variance.ratio}
\alias{variance.ratio}
\title{Variance Ratio}
\usage{
variance.ratio(x, y)
}
\arguments{
\item{x, y}{If \code{y} is not specified then \code{x} must be an object of
class \code{salso.confidence}. Otherwise, \code{x} is a vector of cluster
labels and \code{y} is an expected pairwise allocation matrix.}
}
\value{
A vector of variance ratios.
}
\description{
This function calculates the variance of the expected pairwise allocation
matrix (EPAM) within clusters/subsets over the total variance of the expected
pairwise allocation matrix.
}
\details{
The \code{\link{variance.ratio}} function takes as input an object of class
\code{salso.confidence} and calculates the variance ratio for the estimated
partition from the corresponding expected pairwise allocation matrix (EPAM).

The variance ratio is the weighted average of the within cluster variances of
the EPAM, weighted by the number of pairwise EPAM values per cluster, over
the total variance of the EPAM.
}
\examples{
x <- rep(c(1,2,3), times=c(2,3,5))
y <- diag(10)
y[upper.tri(y)] <- runif(45)
variance.ratio(x,y)

}
\seealso{
Other Default Mass Selection: 
\code{\link{default.mass}()},
\code{\link{mass.algorithm}()},
\code{\link{partition.confidence}()}
}
\concept{Default Mass Selection}
