/*
 * Decompiled with CFR 0.152.
 */
package org.ddahl.shallot.mcmc;

import org.apache.commons.math3.random.RandomDataGenerator;
import org.apache.commons.math3.util.FastMath;
import org.ddahl.sdols.clustering.Clustering;
import org.ddahl.shallot.distribution.HasMass;
import org.ddahl.shallot.distribution.HasMassEscobarWest;
import org.ddahl.shallot.distribution.PartitionModel;
import org.ddahl.shallot.parameter.Mass$;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;

public final class MassSampler$ {
    public static MassSampler$ MODULE$;

    static {
        new MassSampler$();
    }

    public <B extends PartitionModel<A>, A> Tuple2<B, Object> escobarWest(HasMassEscobarWest<B, A> d, Clustering<A> partition, double shape, double rate, RandomDataGenerator rdg) {
        int n = partition.nItems();
        int k = partition.nClusters();
        double eta = rdg.nextBeta(d.mass().value() + 1.0, (double)n);
        double a = shape;
        double b = rate;
        double bMinusLogEta = b - FastMath.log((double)eta);
        double w1 = a + (double)k - 1.0;
        double w2 = (double)n * bMinusLogEta;
        double pi = w1 / (w1 + w2);
        double alpha = rdg.nextUniform(0.0, 1.0, true) < pi ? rdg.nextGamma(a + (double)k, 1.0 / bMinusLogEta) : rdg.nextGamma(a + (double)k - 1.0, 1.0 / bMinusLogEta);
        return new Tuple2(d.replaceMass(Mass$.MODULE$.apply(alpha)), (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }

    public <B extends PartitionModel<A> & HasMass<B, A>, A> Tuple2<B, Object> gaussianRandomWalk(HasMass<B, A> d, Clustering<A> partition, double shape, double rate, double standardDeviation, RandomDataGenerator rdg) {
        PartitionModel current = (PartitionModel)d.self();
        double alpha = rdg.nextGaussian(d.mass().value(), standardDeviation);
        if (alpha <= 0.0) {
            return new Tuple2((Object)current, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        PartitionModel proposal = (PartitionModel)d.replaceMass(Mass$.MODULE$.apply(alpha));
        double logMHRatio = proposal.logProbability(partition) + MassSampler$.logPrior$1(((HasMass)((Object)proposal)).mass().value(), shape, rate) - current.logProbability(partition) - MassSampler$.logPrior$1(((HasMass)((Object)current)).mass().value(), shape, rate);
        return FastMath.log((double)rdg.nextUniform(0.0, 1.0, false)) <= logMHRatio ? new Tuple2((Object)proposal, (Object)BoxesRunTime.boxToBoolean((boolean)true)) : new Tuple2((Object)current, (Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    private static final double logPrior$1(double value, double shape$1, double rate$1) {
        return (shape$1 - 1.0) * FastMath.log((double)value) - rate$1 * value;
    }

    private MassSampler$() {
        MODULE$ = this;
    }
}

