% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgo_ngr.R
\encoding{UTF-8}
\name{sgo_ngr_bng}
\alias{sgo_ngr_bng}
\title{NGR to BNG Easting/Northing}
\usage{
sgo_ngr_bng(x, col = NULL, check.only = FALSE)
}
\arguments{
\item{x}{A data.frame, list or vector containing strings describing OS
National Grid References, with or without whitespace separators.
(e.g. 'SU 387 148').}

\item{col}{Character string with the name of the 'column' containing the
vector of NGR values, it is required when \code{x} is a list with more than
one column.}

\item{check.only}{Logical parameter. If it is set to TRUE then the routine
returns a logical vector indicating which references are correct.}
}
\value{
An object of class \code{sgo_points} whose coordinates are defined as
Easting/Northing when \code{check.only} is kept as FALSE. Otherwise, it
returns a logical vector indicating which grid references are correct and
which ones are not.
}
\description{
Converts OS National Grid References to Easting/Northing coordinates
}
\details{
All entered standard grid references can range from two-digit references up
to 10-digit references (1m × 1m square).
If \code{x} is a list with 2 or more vector elements, \code{col} can be used
to inform the function which of the elements contains the NGR strings. The
rest of the elements will be appended to the resulting object. See examples.
}
\examples{
vec <- c("NN 166 712", "HU38637653")
lst <- list(vec)
v <- sgo_ngr_bng(vec)
l <- sgo_ngr_bng(lst)

# any additional column (here 'attr') will be added to the result
extra <- list(p=c("NN 166712", "HU38637653"),
              attr=c("name1","name2"))
res <- sgo_ngr_bng(extra, col="p")
res

# grid references returned by sgo_bng_ngr are within an
# element (column) named 'ngr'
grid <- sgo_bng_ngr(sgo_points(list(x=247455, y=706338, name="Ben Venue"),
                               coords=c("x","y"),
                               epsg=27700))
bng <- sgo_ngr_bng(grid, col="ngr")

# test
bad <- c("NN 166 712", "AA 3863 7653")
check <- sgo_ngr_bng(bad, check.only=TRUE) #returns a logical vector
}
\seealso{
\code{\link{sgo_points}}, \code{\link{sgo_bng_ngr}}.
}
