% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sf.R
\name{sf}
\alias{sf}
\alias{st_sf}
\alias{[.sf}
\alias{print.sf}
\title{Create sf object}
\usage{
st_sf(
  ...,
  agr = NA_agr_,
  row.names,
  stringsAsFactors = sf_stringsAsFactors(),
  crs,
  precision,
  sf_column_name = NULL,
  check_ring_dir = FALSE,
  sfc_last = TRUE
)

\method{[}{sf}(x, i, j, ..., drop = FALSE, op = st_intersects)

\method{print}{sf}(x, ..., n = getOption("sf_max_print", default = 10))
}
\arguments{
\item{...}{column elements to be binded into an \code{sf} object or a single \code{list} or \code{data.frame} with such columns; at least one of these columns shall be a geometry list-column of class \code{sfc} or be a list-column that can be converted into an \code{sfc} by \link{st_as_sfc}.}

\item{agr}{character vector; see details below.}

\item{row.names}{row.names for the created \code{sf} object}

\item{stringsAsFactors}{logical; see \link{st_read}}

\item{crs}{coordinate reference system, something suitable as input to \link{st_crs}}

\item{precision}{numeric; see \link{st_as_binary}}

\item{sf_column_name}{character; name of the active list-column with simple feature geometries; in case
there is more than one and \code{sf_column_name} is \code{NULL}, the first one is taken.}

\item{check_ring_dir}{see \link{st_read}}

\item{sfc_last}{logical; if \code{TRUE}, \code{sfc} columns are always put last, otherwise column order is left unmodified.}

\item{x}{object of class \code{sf}}

\item{i}{record selection, see \link{[.data.frame}}

\item{j}{variable selection, see \link{[.data.frame}}

\item{drop}{logical, default \code{FALSE}; if \code{TRUE} drop the geometry column and return a \code{data.frame}, else make the geometry sticky and return a \code{sf} object.}

\item{op}{function; geometrical binary predicate function to apply when \code{i} is a simple feature object}

\item{n}{maximum number of features to print; can be set globally by \code{options(sf_max_print=...)}}
}
\description{
Create sf, which extends data.frame-like objects with a simple feature list column
}
\details{
\code{agr}, attribute-geometry-relationship, specifies for each non-geometry attribute column how it relates to the geometry, and can have one of following values: "constant", "aggregate", "identity". "constant" is used for attributes that are constant throughout the geometry (e.g. land use), "aggregate" where the attribute is an aggregate value over the geometry (e.g. population density or population count), "identity" when the attributes uniquely identifies the geometry of particular "thing", such as a building ID or a city name. The default value, \code{NA_agr_}, implies we don't know.

When a single value is provided to \code{agr}, it is cascaded across all input columns; otherwise, a named vector like \code{c(feature1='constant', ...)} will set \code{agr} value to \code{'constant'} for the input column named \code{feature1}. See \code{demo(nc)} for a worked example of this.

When confronted with a data.frame-like object, \code{st_sf} will try to find a geometry column of class \code{sfc}, and otherwise try to convert list-columns when available into a geometry column, using \link{st_as_sfc}.

\code{[.sf} will return a \code{data.frame} or vector if the geometry column (of class \code{sfc}) is dropped (\code{drop=TRUE}), an \code{sfc} object if only the geometry column is selected, and otherwise return an \code{sf} object; see also \link{[.data.frame}; for \code{[.sf} \code{...} arguments are passed to \code{op}.
}
\examples{
g = st_sfc(st_point(1:2))
st_sf(a=3,g)
st_sf(g, a=3)
st_sf(a=3, st_sfc(st_point(1:2))) # better to name it!
# create empty structure with preallocated empty geometries:
nrows <- 10
geometry = st_sfc(lapply(1:nrows, function(x) st_geometrycollection()))
df <- st_sf(id = 1:nrows, geometry = geometry)
g = st_sfc(st_point(1:2), st_point(3:4))
s = st_sf(a=3:4, g)
s[1,]
class(s[1,])
s[,1]
class(s[,1])
s[,2]
class(s[,2])
g = st_sf(a=2:3, g)
pol = st_sfc(st_polygon(list(cbind(c(0,3,3,0,0),c(0,0,3,3,0)))))
h = st_sf(r = 5, pol)
g[h,]
h[g,]
}
