% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{st_write}
\alias{st_write}
\title{write simple features object to file or database}
\usage{
st_write(obj, dsn, layer, driver = "ESRI Shapefile", ...,
  dataset_options = NULL, layer_options = NULL, quiet = FALSE,
  factorsAsCharacter = TRUE)
}
\arguments{
\item{obj}{object of class \code{sf} or \code{sfc}}

\item{dsn}{data source name (interpretation varies by driver - for some drivers, dsn is a file name, but may also be a folder)}

\item{layer}{layer name (varies by driver, may be a file name without extension)}

\item{driver}{character; OGR driver name to be used}

\item{...}{ignored}

\item{dataset_options}{character; driver dependent dataset creation options; multiple options supported.}

\item{layer_options}{character; driver dependent layer creation options; multiple options supported.}

\item{quiet}{logical; suppress info on name, driver, size and spatial reference}

\item{factorsAsCharacter}{logical; convert \code{factor} objects into character strings (default), else into numbers by \code{as.numeric}.}
}
\description{
write simple features object to file or database
}
\details{
columns (variables) of a class not supported are dropped with a warning.
}
\examples{
if (Sys.getenv("USER") \%in\% c("edzer", "travis")) { # load meuse to postgis
 library(sp)
 example(meuse, ask = FALSE, echo = FALSE)
 st_write(st_as_sf(meuse), "PG:dbname=postgis", "meuse_sf", driver = "PostgreSQL",
   layer_options = c("OVERWRITE=yes", "LAUNDER=true"))
 demo(nc, ask = FALSE)
 st_write(nc, "PG:dbname=postgis", "sids", driver = "PostgreSQL", 
   layer_options = "OVERWRITE=true")
}
nc = st_read(system.file("shape/nc.shp", package="sf"), "nc", crs = 4267)
st_write(nc, ".", "nc")
}

