% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_gcv}
\alias{plot_gcv}
\title{Plotting GCV values with respect to different nn-s and h-s parameters.}
\usage{
plot_gcv(age, pos, tot, nn_seq, h_seq, kern = "tcub", deg = 2)
}
\arguments{
\item{age}{the age vector.}

\item{pos}{the pos vector.}

\item{tot}{the tot vector.#'}

\item{nn_seq}{Nearest neighbor sequence.}

\item{h_seq}{Smoothing parameter sequence.}

\item{kern}{Weight function, default = "tcub".
Other choices are "rect", "trwt", "tria", "epan", "bisq" and "gauss".
Choices may be restricted when derivatives are required;
e.g. for confidence bands and some bandwidth selectors.}

\item{deg}{Degree of polynomial to use. Default: 2.}
}
\value{
plot of gcv value
}
\description{
Refers to section 7.2.
}
\examples{
df <- mumps_uk_1986_1987
plot_gcv(
  df$age, df$pos, df$tot,
  nn_seq = seq(0.2, 0.8, by=0.1),
  h_seq = seq(5, 25, by=1)
)

}
