% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_curve_params.R
\name{load_curve_params}
\alias{load_curve_params}
\title{Load antibody decay curve parameter samples}
\usage{
load_curve_params(file_path, antigen_isos = NULL)
}
\arguments{
\item{file_path}{path to an RDS file containing MCMC samples of antibody decay curve parameters \code{y0}, \code{y1}, \code{t1}, \code{alpha}, and \code{r}, stored as a \code{\link[=data.frame]{data.frame()}} or \link[tibble:tbl_df-class]{tibble::tbl_df}}

\item{antigen_isos}{\code{\link[=character]{character()}} vector of antigen isotypes to be used in analyses}
}
\value{
a \code{curve_params} object (a \link[tibble:tbl_df-class]{tibble::tbl_df} with extra attribute \code{antigen_isos})
}
\description{
Load antibody decay curve parameter samples
}
\examples{
\donttest{
curve <- load_curve_params("https://osf.io/download/rtw5k/")

print(curve)
}

}
