% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data_documentation.R
\docType{data}
\name{SeqOUT_griffin}
\alias{SeqOUT_griffin}
\title{Example sequoia output (griffins)}
\format{
a list, see \code{\link{sequoia}}
}
\usage{
data(SeqOUT_griffin)
}
\description{
Example output of a sequoia run including sibship clustering,
based on the griffin pedigree.
}
\examples{
\dontrun{
GenoS <- SimGeno(Ped.griffin, nSnp=400, ParMis=0.4)
griffin.sex <- sapply(Ped.griffin$ID,
                    function(x) substr(x, start=nchar(x), stop=nchar(x)))
LH_griffin <- data.frame(ID = Ped_griffin$ID,
                         Sex = ifelse(griffin.sex=="F", 1, 2),
                         BirthYear = Ped_griffin$BY)
SeqOUT_griffin <- sequoia(GenoS, LH_griffin,
                  MaxSibIter = 10,
                  args.AP = list(Smooth = FALSE)) }
}
\seealso{
\code{\link{Ped_griffin}, \link{sequoia}}
}
\author{
Jisca Huisman, \email{jisca.huisman@gmail.com}
}
\keyword{datasets}
\keyword{sequoia}
