% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logit_model_cat.R
\name{logit_model}
\alias{logit_model}
\title{the individualized binary logistic regression for categorical response
  data.}
\usage{
logit_model(splitted, newY)
}
\arguments{
\item{splitted}{A list containing the datasets which we will use in the
categorical case. Note that the element of the splitted is the collections
of samples from Classes 0 and Classes k.}

\item{newY}{A numeric number denotes the value of the labels from 0 to K
which is the number of categories}
}
\value{
\item{beta_mat}{a matrix contains the estimated coefficient. Note that the
beta_mat is a n * p matrix which n is the number of the explanatory variables
and p+1 is the number of categories}
}
\description{
\code{logit_model} fit the categorical data by the individualized binary
logistic regression
}
\details{
logit_model fits the splitted data by using the the individualized binary
logistic regression according to the value of newY. Because we use use Class
0 as the baseline for modeling the probability ratio of Class k to Class 0 by
fitting K individual logistic models, if newY equal to 0, it means we need
fit all elements of the splitted data. Otherwise, we only fit the samples
from class 0 and class newY.
}
\examples{
## For an example, see example(seq_cat_model)
}
\references{
{
Li, J., Chen, Z., Wang, Z., & Chang, Y. I. (2020). Active learning in
multiple-class classification problems via individualized binary models.
\emph{Computational Statistics & Data Analysi}, 145, 106911.
doi:10.1016/j.csda.2020.106911
}
}
\seealso{
{
   \code{\link{logit_model_ord}} for ordinal case.

}
}
