% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_metadata_years.R
\name{get_metadata_years}
\alias{get_metadata_years}
\title{Returns metadata to construct x-axis and legend of \code{\link[sephora]{plot.sephora}}}
\usage{
get_metadata_years(x, startYear = 2000, endYear = 2021, frequency = 23)
}
\arguments{
\item{x}{numeric vector or \code{\link[sephora]{sephora-class}} object}

\item{startYear}{integer, \code{x} initial year}

\item{endYear}{integer, \code{x} final year}

\item{frequency}{integer giving number of observations per season. 
Default is 23.}
}
\value{
A list of 2 components: 
\item{xDates}{date vector containing DoY (acquisition date) using format yyyy-mm-dd}
\item{xLabels}{character vector containing period of study years using format "'YY"}
}
\description{
Metadata either from a numeric vector or a \code{\link[sephora]{sephora-class}} object
}
\examples{
x <- deciduous_polygon[1,]
y <- get_metadata_years(x=x)
str(y)

}
