% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{fit.sentopicmodel}
\alias{fit.sentopicmodel}
\alias{grow}
\alias{fit.LDA}
\alias{fit.rJST}
\alias{fit.JST}
\alias{fit.multiChains}
\alias{grow.LDA}
\alias{grow.rJST}
\alias{grow.JST}
\alias{grow.sentopicmodel}
\alias{grow.multiChains}
\title{Estimate a topic model}
\usage{
\method{fit}{sentopicmodel}(
  object,
  iterations = 100,
  nChains = 1,
  displayProgress = TRUE,
  computeLikelihood = TRUE,
  seed = NULL,
  ...
)

\method{fit}{multiChains}(
  object,
  iterations = 100,
  nChains = NULL,
  displayProgress = TRUE,
  computeLikelihood = TRUE,
  seed = NULL,
  ...
)
}
\arguments{
\item{object}{a model created with the \code{\link[=LDA]{LDA()}}, \code{\link[=JST]{JST()}} or \code{\link[=rJST]{rJST()}} function.}

\item{iterations}{the number of iterations by which the model should be
fitted.}

\item{nChains}{if set above 1, the model will be fitted multiple times
from various starting positions. Latent variables will be re-initialized if
\code{object} has not been fitted before.}

\item{displayProgress}{if \code{TRUE}, a progress bar will be displayed indicating
the progress of the computation. When \code{nChains} is greater than 1, this
requires the package \pkg{progressr} and optionally \pkg{progress}.}

\item{computeLikelihood}{if set to \code{FALSE}, does not compute the likelihood
at each iteration. This can slightly decrease the computing time.}

\item{seed}{for reproducibility, a seed can be provided.}

\item{...}{arguments passed to other methods. Not used.}
}
\value{
a \code{sentopicmodel} of the relevant model class if \code{nChains} is
unspecified or equal to 1. A \code{multiChains} object if \code{nChains} is greater
than 1.
}
\description{
This function is used to estimate a topic model created by
\code{\link[=LDA]{LDA()}}, \code{\link[=JST]{JST()}} or \code{\link[=rJST]{rJST()}}. In essence, this function iterates a Gibbs
sampler MCMC.
}
\section{Parallelism}{
 When \code{nChains > 1}, the function can take advantage of
\link[future.apply:future_lapply]{future.apply::future_lapply} (if installed) to spread the computation over
multiple processes. This requires the specification of a parallel strategy
using \code{\link[future:plan]{future::plan()}}. See the examples below.
}

\examples{
model <- rJST(ECB_press_conferences_tokens)
fit(model, 10)

# -- Parallel computation --
require(future.apply)
future::plan("multisession", workers = 2) # Set up 2 workers
fit(model, 10, nChains = 2)

future::plan("sequential") # Shut down workers
}
\seealso{
\code{\link[=LDA]{LDA()}}, \code{\link[=JST]{JST()}}, \code{\link[=rJST]{rJST()}}, \code{\link[=reset]{reset()}}
}
