% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentometrics.R
\docType{data}
\name{epu}
\alias{epu}
\title{Monthly Economic Policy Uncertainty Index}
\format{A \code{data.frame} with 403 rows and 4 columns.}
\source{
\href{http://www.policyuncertainty.com/us_monthly.html}{Measuring Economic Policy Uncertainty}. Retrieved
August 24, 2018.
}
\usage{
data("epu")
}
\description{
Monthly news-based U.S. Economic Policy Uncertainty (EPU) index (Baker, Bloom and Davis, 2015). Goes from January 1985
to July 2018, and includes a binomial and a multinomial example series. Following columns are present:

\itemize{
  \item date. Date as \code{"yyyy-mm-01"}.
  \item index. A \code{numeric} monthly index value.
  \item above. A \code{factor} with value \code{"above"} if the index is greater than the mean of the entire series, else
  \code{"below"}.
  \item aboveMulti. A \code{factor} with values \code{"above+"}, \code{"above"}, \code{"below"} and \code{"below-"} if the
  index is greater than the 75\% quantile and the 50\% quantile, or smaller than the 50\% quantile and the 25\% quantile,
  respectively and in a mutually exclusive sense.
}
}
\examples{
data("epu", package = "sentometrics")
head(epu)

}
\references{
Baker, Bloom and Davis (2015). ``Measuring Economic Policy Uncertainty''.
\emph{NBER Working Paper No. 21633}, \url{http://www.nber.org/papers/w21633}.
}
\keyword{datasets}
