% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentomodel.R
\name{plot.sentomodeliter}
\alias{plot.sentomodeliter}
\title{Plot iterative predictions versus realized values}
\usage{
\method{plot}{sentomodeliter}(x, ...)
}
\arguments{
\item{x}{a \code{sentomodeliter} object created using \code{\link{sento_model}}.}

\item{...}{not used.}
}
\value{
Returns a simple \code{\link{ggplot}} object, which can be added onto (or to alter its default elements) by using
the \code{+} operator (see examples).
}
\description{
Displays a plot of all predictions made through the iterative model computation as incorporated in the
input \code{sentomodeliter} object, as well as the corresponding true values.
}
\examples{
\dontrun{
data("usnews", package = "sentometrics")
data("list_lexicons", package = "sentometrics")
data("list_valence_shifters", package = "sentometrics")
data("epu", package = "sentometrics")

# construct a sentomeasures object to start with
corpusAll <- sento_corpus(corpusdf = usnews)
corpus <- quanteda::corpus_subset(corpusAll, date >= "2007-01-01" & date < "2014-10-01")
l <- setup_lexicons(list_lexicons[c("LM_en", "HENRY_en")], list_valence_shifters[["en"]])
ctr <- ctr_agg(howWithin = "tf-idf", howDocs = "proportional",
               howTime = c("equal_weight", "linear"),
               by = "month", lag = 3)
sentomeasures <- sento_measures(corpus, l, ctr)

# prepare y variable
y <- epu[epu$date >= sentomeasures$measures$date[1], ]$index
length(y) == nobs(sentomeasures) # TRUE

# estimate regression iteratively based on a sample of 60, skipping first 25 iterations
ctr <- ctr_model(model = "gaussian", type = "AIC", do.iter = TRUE,
                 h = 0, nSample = 60, start = 26)
out <- sento_model(sentomeasures, y, ctr = ctr)
summary(out)

# plotting
p <- plot(out)
p <- p +
  ggthemes::theme_few()
p}

}
\author{
Samuel Borms
}
