% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentomeasures.R
\name{ctr_merge}
\alias{ctr_merge}
\title{Set up control for merging sentiment measures}
\usage{
ctr_merge(sentomeasures, features = NA, lexicons = NA, time = NA,
  do.keep = FALSE)
}
\arguments{
\item{sentomeasures}{a \code{sentomeasures} object created using \code{\link{sento_measures}}. This is necessary to check
whether the other input arguments make sense.}

\item{features}{a \code{list} with unique features to merge at given name, e.g., \cr
\code{list(feat12 = c("feat1", "feat2"))}. See \code{sentomeasures$features} for the exact names to use. Use \code{NA} to
apply no merging across this dimension.}

\item{lexicons}{a \code{list} with unique lexicons to merge at given name, e.g., \cr
\code{list(lex12 = c("lex1", "lex2"))}. See \code{sentomeasures$lexicons} for the exact names to use. Use \code{NA} to
apply no merging across this dimension.}

\item{time}{a \code{list} with unique time weighting schemes to merge at given name, e.g., \cr
\code{list(tw12 = c("tw1", "tw2"))}. See \code{sentomeasures$time} for the exact names to use. Use \code{NA} to
apply no merging across this dimension.}

\item{do.keep}{a \code{logical} indicating if the original sentiment measures should be kept (i.e., the merged
sentiment measures will be added to the current sentiment measures as additional indices if \code{do.keep = TRUE}).}
}
\value{
A \code{list} encapsulating the control parameters.
}
\description{
Sets up control object for the optional merging (additional aggregation) of sentiment measures as
done by \code{\link{merge_measures}}.
}
\examples{
data("usnews")
data("lexicons")
data("valence")

# construct a sentomeasures object to start with
corpus <- sento_corpus(corpusdf = usnews)
corpusSample <- quanteda::corpus_sample(corpus, size = 750)
l <- setup_lexicons(lexicons[c("LM_eng", "HENRY_eng")], valence[["valence_eng"]])
ctr <- ctr_agg(howTime = c("equal_weight", "linear"), by = "year", lag = 3)
sentomeasures <- sento_measures(corpusSample, l, ctr)

# set up a correct control function
ctrMerge <- ctr_merge(sentomeasures,
                      time = list(W = c("equal_weight", "linear")),
                      lexicons = list(LEX = c("LM_eng", "HENRY_eng")),
                      features = list(journals = c("wsj", "wapo")),
                      do.keep = TRUE)

\dontrun{
# produces an informative error message
ctrMerge <- ctr_merge(sentomeasures,
                      time = list(W = c("equal_weight", "almon1")),
                      lexicons = list(LEX = c("LM_eng", "HENRY_eng")),
                      features = list(journals = c("notInHere", "wapo")))}

}
\seealso{
\code{\link{merge_measures}}
}
\author{
Samuel Borms
}
