% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/presenter.R, R/semnar-package.R
\name{set_presenter.semnar}
\alias{set_presenter.semnar}
\alias{set_presenter}
\title{Set presenter information from a \code{\link{semnar}} object}
\usage{
\method{set_presenter}{semnar}(object, presenter)

set_presenter(object, presenter)
}
\arguments{
\item{object}{either an object an object of class \code{\link{semnar}}.}

\item{presenter}{an object of class \code{\link{semnar_presenter}}.}
}
\value{
The \code{\link{semnar}} object supplied in \code{object}, with the
presenter information as in \code{presenter}. See the output of
\code{semnar:::get_presenter_variables()} for what variables are
affected.
}
\description{
Set presenter information from a \code{\link{semnar}} object
}
\examples{
out <- add_presentation(presenter_name = "Ioannis",
                        presenter_surname = "Kosmidis",
                        presenter_affiliation = "University of Warwick",
                        title = "A") |>
       add_presentation(presenter_name = "Ioannis",
                        presenter_surname = "Kosmidis",
                        presenter_affiliation = "University College London",
                        title = "B") |>
       add_presentation(presenter_name = "Ioannis",
                        presenter_surname = "Kosmidis",
                        presenter_affiliation = "University College London",
                        title = "C")
john_doe <- presenter(name = "John",
                      surname = "Doe",
                      affiliation = "Nowhereland",
                      link = "https://johndoe.nowhereland.com",
                      email = "john.doe@nowhereland.com")
out
set_presenter(out, john_doe)
}
\seealso{
presenter get_presenter
}
