% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semmcci-mc-std.R
\name{MCStd}
\alias{MCStd}
\title{Standardized Monte Carlo Confidence Intervals}
\usage{
MCStd(object, alpha = c(0.001, 0.01, 0.05))
}
\arguments{
\item{object}{object of class \code{semmcci}.
Output of the \code{MC()} function.}

\item{alpha}{Numeric vector.
Significance level \eqn{\alpha}.
Default value is \code{alpha = c(0.001, 0.01, 0.05)}.}
}
\value{
Returns an object of class \code{semmccistd}
which is a list with the following elements:
\describe{
\item{\code{R}}{Number of Monte Carlo replications.}
\item{\code{alpha}}{Significance level \eqn{\alpha} specified.}
\item{\code{lavaan}}{\code{lavaan} object.}
\item{\code{decomposition}}{Matrix decomposition
used to generate multivariate normal
random variates.}
\item{\code{thetahat}}{Parameter estimates \eqn{\hat{\theta}}.}
\item{\code{thetahatstar}}{Sampling distribution of parameter estimates
\eqn{\hat{\theta}^{\ast}}.}
\item{\code{ci}}{Confidence intervals.}
\item{\code{thetahat_std}}{Standardized parameter estimates
\eqn{\hat{\theta}_{\mathrm{std}}}.}
\item{\code{thetahatstar_std}}{Standardized sampling distribution
of parameter estimates
\eqn{\hat{\theta}^{\ast}_{\mathrm{std}}}.}
}
}
\description{
Calculates standardized Monte Carlo confidence intervals
for free and defined parameters.
}
\details{
The empirical sampling distribution
of parameter estimates from the argument \code{object} is standardized,
that is, each randomly generated vector of parameters is standardized.
Defined parameters are computed from the standardized component parameters.
Confidence intervals are generated
using the standardized empirical sampling distribution.
}
\examples{
library(semmcci)
library(lavaan)

# Generate Data ------------------------------------------------------------
n <- 1000
a <- 0.50
b <- 0.50
cp <- 0.25
s2_em <- 1 - a^2
s2_ey <- 1 - cp^2 - a^2 * b^2 - b^2 * s2_em - 2 * cp * a * b
em <- rnorm(n = n, mean = 0, sd = sqrt(s2_em))
ey <- rnorm(n = n, mean = 0, sd = sqrt(s2_ey))
X <- rnorm(n = n)
M <- a * X + em
Y <- cp * X + b * M + ey
df <- data.frame(X, M, Y)

# Fit Model in lavaan ------------------------------------------------------
model <- "
  Y ~ cp * X + b * M
  M ~ a * X
  indirect := a * b
  direct := cp
  total := cp + (a * b)
"
fit <- sem(data = df, model = model, fixed.x = FALSE)

# Monte Carlo --------------------------------------------------------------
output <- MC(
  fit,
  R = 100L, # use a large value e.g., 20000L for actual research
  alpha = c(0.001, 0.01, 0.05)
)

# Standardized Monte Carlo -------------------------------------------------
MCStd(output)
}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{mc}
