% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semmcci-methods.R
\name{coef.semmccistd}
\alias{coef.semmccistd}
\title{Standardized Parameter Estimates}
\usage{
\method{coef}{semmccistd}(object, ...)
}
\arguments{
\item{object}{Object of class \code{semmccistd}.}

\item{...}{additional arguments.}
}
\value{
Returns a vector of standardized parameter estimates.
}
\description{
Standardized Parameter Estimates
}
\examples{
library(semmcci)
library(lavaan)

# Generate Data ------------------------------------------------------------
n <- 1000
x <- rnorm(n = n)
m <- 0.50 * x + rnorm(n = n)
y <- 0.25 * x + 0.50 * m + rnorm(n = n)
data <- data.frame(x, m, y)

# Fit Model in lavaan ------------------------------------------------------
model <- "
  y ~ cp * x + b * m
  m ~ a * x
  ab := a * b
"
fit <- sem(data = data, model = model, fixed.x = FALSE)

# Monte Carlo --------------------------------------------------------------
unstd <- MC(
  fit,
  R = 100L, # use a large value e.g., 20000L for actual research
  alpha = c(0.001, 0.01, 0.05)
)

# Standardized Monte Carlo -------------------------------------------------
std <- MCStd(unstd)
coef(std)
}
\author{
Ivan Jacob Agaloos Pesigan
}
\keyword{method}
