% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_fit_measures_change.R
\name{print.fit_measures_change}
\alias{print.fit_measures_change}
\title{Print a 'fit_measures_change' Class Object}
\usage{
\method{print}{fit_measures_change}(
  x,
  digits = 3,
  first = 10,
  sort_by = NULL,
  decreasing = TRUE,
  absolute = TRUE,
  ...
)
}
\arguments{
\item{x}{An 'fit_measures_change'-class object.}

\item{digits}{The number of digits after the decimal.
Default is 3.}

\item{first}{Numeric. If not \code{NULL}, it prints
only the first \emph{k} cases, \emph{k} equal to \code{first}.
Default is 10.}

\item{sort_by}{String. Default is \code{NULL} and
the output is not sorted. If set to a column
names of \code{x}, cases will sorted by this columns.
The sorting is done on the absolute values
if \code{absolute} is \code{TRUE}, and in decreasing
order if \code{decreasing} is \code{TRUE}. If \code{decrease}
is \code{FALSE}, the order is increasing. If \code{absolute}
is \code{FALSE}, the sorting is done on the raw values.}

\item{decreasing}{Logical. Whether cases, if sorted,
is on decreasing order. Default is \code{TRUE}. See \code{sort_by}.}

\item{absolute}{Logical. Whether cases, if sorted,
are sorted on absolute values. Default is \code{TRUE}.
See \code{sort_by}.}

\item{...}{Other arguments. They will be ignored.}
}
\value{
\code{x} is returned invisibly. Called for its side effect.
}
\description{
Print the content of a 'fit_measures_change'-class object.
}
\details{
All the functions on case influence
on fit measures, \code{\link[=fit_measures_change]{fit_measures_change()}}
and \code{\link[=fit_measures_change_approx]{fit_measures_change_approx()}}, return
an \code{fit_measures_change}-class object. This method will print
the output, with the option to sort the cases.
}
\examples{

library(lavaan)

# A path model

dat <- pa_dat
mod <-
"
m1 ~ a1 * iv1 + a2 * iv2
dv ~ b * m1
a1b := a1 * b
a2b := a2 * b
"
# Fit the model
fit <- lavaan::sem(mod, dat)
summary(fit)

# Case influence
out <- fit_measures_change_approx(fit)
out
print(out, sort_by = "chisq", first = 5)

fit_rerun <- lavaan_rerun(fit, parallel = FALSE,
                          to_rerun = c(2, 3, 5, 7))#'
out <- fit_measures_change(fit_rerun)
out
print(out, sort_by = "chisq", first = 5)

}
\seealso{
\code{\link[=fit_measures_change]{fit_measures_change()}}, \code{\link[=fit_measures_change_approx]{fit_measures_change_approx()}}
}
